package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.NetworkFirewallAction
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallPolicyDescription(
    statelessRuleGroups: Option[
      Iterable[zio.aws.fms.model.StatelessRuleGroup]
    ] = None,
    statelessDefaultActions: Option[Iterable[NetworkFirewallAction]] = None,
    statelessFragmentDefaultActions: Option[Iterable[NetworkFirewallAction]] =
      None,
    statelessCustomActions: Option[Iterable[NetworkFirewallAction]] = None,
    statefulRuleGroups: Option[Iterable[zio.aws.fms.model.StatefulRuleGroup]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyDescription = {
    import NetworkFirewallPolicyDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyDescription
      .builder()
      .optionallyWith(
        statelessRuleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statelessRuleGroups)
      .optionallyWith(
        statelessDefaultActions.map(value =>
          value.map { item =>
            NetworkFirewallAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statelessDefaultActions)
      .optionallyWith(
        statelessFragmentDefaultActions.map(value =>
          value.map { item =>
            NetworkFirewallAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statelessFragmentDefaultActions)
      .optionallyWith(
        statelessCustomActions.map(value =>
          value.map { item =>
            NetworkFirewallAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statelessCustomActions)
      .optionallyWith(
        statefulRuleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statefulRuleGroups)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly =
    zio.aws.fms.model.NetworkFirewallPolicyDescription.wrap(buildAwsValue())
}
object NetworkFirewallPolicyDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.NetworkFirewallPolicyDescription =
      zio.aws.fms.model.NetworkFirewallPolicyDescription(
        statelessRuleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statelessDefaultActions.map(value => value),
        statelessFragmentDefaultActions.map(value => value),
        statelessCustomActions.map(value => value),
        statefulRuleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def statelessRuleGroups
        : Option[List[zio.aws.fms.model.StatelessRuleGroup.ReadOnly]]
    def statelessDefaultActions: Option[List[NetworkFirewallAction]]
    def statelessFragmentDefaultActions: Option[List[NetworkFirewallAction]]
    def statelessCustomActions: Option[List[NetworkFirewallAction]]
    def statefulRuleGroups
        : Option[List[zio.aws.fms.model.StatefulRuleGroup.ReadOnly]]
    def getStatelessRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.fms.model.StatelessRuleGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("statelessRuleGroups", statelessRuleGroups)
    def getStatelessDefaultActions
        : ZIO[Any, AwsError, List[NetworkFirewallAction]] = AwsError
      .unwrapOptionField("statelessDefaultActions", statelessDefaultActions)
    def getStatelessFragmentDefaultActions
        : ZIO[Any, AwsError, List[NetworkFirewallAction]] =
      AwsError.unwrapOptionField(
        "statelessFragmentDefaultActions",
        statelessFragmentDefaultActions
      )
    def getStatelessCustomActions
        : ZIO[Any, AwsError, List[NetworkFirewallAction]] = AwsError
      .unwrapOptionField("statelessCustomActions", statelessCustomActions)
    def getStatefulRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.fms.model.StatefulRuleGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("statefulRuleGroups", statefulRuleGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyDescription
  ) extends zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly {
    override val statelessRuleGroups
        : Option[List[zio.aws.fms.model.StatelessRuleGroup.ReadOnly]] = scala
      .Option(impl.statelessRuleGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.StatelessRuleGroup.wrap(item)
        }.toList
      )
    override val statelessDefaultActions: Option[List[NetworkFirewallAction]] =
      scala
        .Option(impl.statelessDefaultActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.primitives.NetworkFirewallAction(item)
          }.toList
        )
    override val statelessFragmentDefaultActions
        : Option[List[NetworkFirewallAction]] = scala
      .Option(impl.statelessFragmentDefaultActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.primitives.NetworkFirewallAction(item)
        }.toList
      )
    override val statelessCustomActions: Option[List[NetworkFirewallAction]] =
      scala
        .Option(impl.statelessCustomActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.primitives.NetworkFirewallAction(item)
          }.toList
        )
    override val statefulRuleGroups
        : Option[List[zio.aws.fms.model.StatefulRuleGroup.ReadOnly]] = scala
      .Option(impl.statefulRuleGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.StatefulRuleGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyDescription
  ): zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly = new Wrapper(
    impl
  )
}
