package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PolicyOption(
    networkFirewallPolicy: Option[zio.aws.fms.model.NetworkFirewallPolicy] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PolicyOption = {
    import PolicyOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PolicyOption
      .builder()
      .optionallyWith(
        networkFirewallPolicy.map(value => value.buildAwsValue())
      )(_.networkFirewallPolicy)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PolicyOption.ReadOnly =
    zio.aws.fms.model.PolicyOption.wrap(buildAwsValue())
}
object PolicyOption {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.PolicyOption] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PolicyOption = zio.aws.fms.model
      .PolicyOption(networkFirewallPolicy.map(value => value.asEditable))
    def networkFirewallPolicy
        : Option[zio.aws.fms.model.NetworkFirewallPolicy.ReadOnly]
    def getNetworkFirewallPolicy
        : ZIO[Any, AwsError, zio.aws.fms.model.NetworkFirewallPolicy.ReadOnly] =
      AwsError.unwrapOptionField("networkFirewallPolicy", networkFirewallPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PolicyOption
  ) extends zio.aws.fms.model.PolicyOption.ReadOnly {
    override val networkFirewallPolicy
        : Option[zio.aws.fms.model.NetworkFirewallPolicy.ReadOnly] = scala
      .Option(impl.networkFirewallPolicy())
      .map(value => zio.aws.fms.model.NetworkFirewallPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PolicyOption
  ): zio.aws.fms.model.PolicyOption.ReadOnly = new Wrapper(impl)
}
