package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutAppsListResponse(
    appsList: Option[zio.aws.fms.model.AppsListData] = None,
    appsListArn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PutAppsListResponse = {
    import PutAppsListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PutAppsListResponse
      .builder()
      .optionallyWith(appsList.map(value => value.buildAwsValue()))(_.appsList)
      .optionallyWith(
        appsListArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.appsListArn)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PutAppsListResponse.ReadOnly =
    zio.aws.fms.model.PutAppsListResponse.wrap(buildAwsValue())
}
object PutAppsListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.PutAppsListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PutAppsListResponse =
      zio.aws.fms.model.PutAppsListResponse(
        appsList.map(value => value.asEditable),
        appsListArn.map(value => value)
      )
    def appsList: Option[zio.aws.fms.model.AppsListData.ReadOnly]
    def appsListArn: Option[ResourceArn]
    def getAppsList
        : ZIO[Any, AwsError, zio.aws.fms.model.AppsListData.ReadOnly] =
      AwsError.unwrapOptionField("appsList", appsList)
    def getAppsListArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("appsListArn", appsListArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PutAppsListResponse
  ) extends zio.aws.fms.model.PutAppsListResponse.ReadOnly {
    override val appsList: Option[zio.aws.fms.model.AppsListData.ReadOnly] =
      scala
        .Option(impl.appsList())
        .map(value => zio.aws.fms.model.AppsListData.wrap(value))
    override val appsListArn: Option[ResourceArn] = scala
      .Option(impl.appsListArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PutAppsListResponse
  ): zio.aws.fms.model.PutAppsListResponse.ReadOnly = new Wrapper(impl)
}
