package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutProtocolsListResponse(
    protocolsList: Option[zio.aws.fms.model.ProtocolsListData] = None,
    protocolsListArn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PutProtocolsListResponse = {
    import PutProtocolsListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PutProtocolsListResponse
      .builder()
      .optionallyWith(protocolsList.map(value => value.buildAwsValue()))(
        _.protocolsList
      )
      .optionallyWith(
        protocolsListArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.protocolsListArn)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PutProtocolsListResponse.ReadOnly =
    zio.aws.fms.model.PutProtocolsListResponse.wrap(buildAwsValue())
}
object PutProtocolsListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.PutProtocolsListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PutProtocolsListResponse =
      zio.aws.fms.model.PutProtocolsListResponse(
        protocolsList.map(value => value.asEditable),
        protocolsListArn.map(value => value)
      )
    def protocolsList: Option[zio.aws.fms.model.ProtocolsListData.ReadOnly]
    def protocolsListArn: Option[ResourceArn]
    def getProtocolsList
        : ZIO[Any, AwsError, zio.aws.fms.model.ProtocolsListData.ReadOnly] =
      AwsError.unwrapOptionField("protocolsList", protocolsList)
    def getProtocolsListArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("protocolsListArn", protocolsListArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PutProtocolsListResponse
  ) extends zio.aws.fms.model.PutProtocolsListResponse.ReadOnly {
    override val protocolsList
        : Option[zio.aws.fms.model.ProtocolsListData.ReadOnly] = scala
      .Option(impl.protocolsList())
      .map(value => zio.aws.fms.model.ProtocolsListData.wrap(value))
    override val protocolsListArn: Option[ResourceArn] = scala
      .Option(impl.protocolsListArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PutProtocolsListResponse
  ): zio.aws.fms.model.PutProtocolsListResponse.ReadOnly = new Wrapper(impl)
}
