package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{ResourceTagValue, ResourceTagKey}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceTag(
    key: ResourceTagKey,
    value: Option[ResourceTagValue] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.fms.model.ResourceTag = {
    import ResourceTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ResourceTag
      .builder()
      .key(ResourceTagKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => ResourceTagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ResourceTag.ReadOnly =
    zio.aws.fms.model.ResourceTag.wrap(buildAwsValue())
}
object ResourceTag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.ResourceTag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ResourceTag =
      zio.aws.fms.model.ResourceTag(key, value.map(value => value))
    def key: ResourceTagKey
    def value: Option[ResourceTagValue]
    def getKey: ZIO[Any, Nothing, ResourceTagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, ResourceTagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ResourceTag
  ) extends zio.aws.fms.model.ResourceTag.ReadOnly {
    override val key: ResourceTagKey =
      zio.aws.fms.model.primitives.ResourceTagKey(impl.key())
    override val value: Option[ResourceTagValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.fms.model.primitives.ResourceTagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ResourceTag
  ): zio.aws.fms.model.ResourceTag.ReadOnly = new Wrapper(impl)
}
