package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{LengthBoundedString, ResourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RouteHasOutOfScopeEndpointViolation(
    subnetId: Option[ResourceId] = None,
    vpcId: Option[ResourceId] = None,
    routeTableId: Option[ResourceId] = None,
    violatingRoutes: Option[Iterable[zio.aws.fms.model.Route]] = None,
    subnetAvailabilityZone: Option[LengthBoundedString] = None,
    subnetAvailabilityZoneId: Option[LengthBoundedString] = None,
    currentFirewallSubnetRouteTable: Option[ResourceId] = None,
    firewallSubnetId: Option[ResourceId] = None,
    firewallSubnetRoutes: Option[Iterable[zio.aws.fms.model.Route]] = None,
    internetGatewayId: Option[ResourceId] = None,
    currentInternetGatewayRouteTable: Option[ResourceId] = None,
    internetGatewayRoutes: Option[Iterable[zio.aws.fms.model.Route]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation = {
    import RouteHasOutOfScopeEndpointViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation
      .builder()
      .optionallyWith(
        subnetId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .optionallyWith(
        violatingRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violatingRoutes)
      .optionallyWith(
        subnetAvailabilityZone.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.subnetAvailabilityZone)
      .optionallyWith(
        subnetAvailabilityZoneId.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.subnetAvailabilityZoneId)
      .optionallyWith(
        currentFirewallSubnetRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentFirewallSubnetRouteTable)
      .optionallyWith(
        firewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallSubnetId)
      .optionallyWith(
        firewallSubnetRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firewallSubnetRoutes)
      .optionallyWith(
        internetGatewayId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.internetGatewayId)
      .optionallyWith(
        currentInternetGatewayRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentInternetGatewayRouteTable)
      .optionallyWith(
        internetGatewayRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.internetGatewayRoutes)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.ReadOnly =
    zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.wrap(buildAwsValue())
}
object RouteHasOutOfScopeEndpointViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation =
      zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation(
        subnetId.map(value => value),
        vpcId.map(value => value),
        routeTableId.map(value => value),
        violatingRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subnetAvailabilityZone.map(value => value),
        subnetAvailabilityZoneId.map(value => value),
        currentFirewallSubnetRouteTable.map(value => value),
        firewallSubnetId.map(value => value),
        firewallSubnetRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        internetGatewayId.map(value => value),
        currentInternetGatewayRouteTable.map(value => value),
        internetGatewayRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subnetId: Option[ResourceId]
    def vpcId: Option[ResourceId]
    def routeTableId: Option[ResourceId]
    def violatingRoutes: Option[List[zio.aws.fms.model.Route.ReadOnly]]
    def subnetAvailabilityZone: Option[LengthBoundedString]
    def subnetAvailabilityZoneId: Option[LengthBoundedString]
    def currentFirewallSubnetRouteTable: Option[ResourceId]
    def firewallSubnetId: Option[ResourceId]
    def firewallSubnetRoutes: Option[List[zio.aws.fms.model.Route.ReadOnly]]
    def internetGatewayId: Option[ResourceId]
    def currentInternetGatewayRouteTable: Option[ResourceId]
    def internetGatewayRoutes: Option[List[zio.aws.fms.model.Route.ReadOnly]]
    def getSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getViolatingRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("violatingRoutes", violatingRoutes)
    def getSubnetAvailabilityZone: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZone",
        subnetAvailabilityZone
      )
    def getSubnetAvailabilityZoneId: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZoneId",
        subnetAvailabilityZoneId
      )
    def getCurrentFirewallSubnetRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentFirewallSubnetRouteTable",
        currentFirewallSubnetRouteTable
      )
    def getFirewallSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallSubnetId", firewallSubnetId)
    def getFirewallSubnetRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("firewallSubnetRoutes", firewallSubnetRoutes)
    def getInternetGatewayId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("internetGatewayId", internetGatewayId)
    def getCurrentInternetGatewayRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentInternetGatewayRouteTable",
        currentInternetGatewayRouteTable
      )
    def getInternetGatewayRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("internetGatewayRoutes", internetGatewayRoutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation
  ) extends zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.ReadOnly {
    override val subnetId: Option[ResourceId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val vpcId: Option[ResourceId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val routeTableId: Option[ResourceId] = scala
      .Option(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val violatingRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]] = scala
      .Option(impl.violatingRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Route.wrap(item)
        }.toList
      )
    override val subnetAvailabilityZone: Option[LengthBoundedString] = scala
      .Option(impl.subnetAvailabilityZone())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val subnetAvailabilityZoneId: Option[LengthBoundedString] = scala
      .Option(impl.subnetAvailabilityZoneId())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val currentFirewallSubnetRouteTable: Option[ResourceId] = scala
      .Option(impl.currentFirewallSubnetRouteTable())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val firewallSubnetId: Option[ResourceId] = scala
      .Option(impl.firewallSubnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val firewallSubnetRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]] = scala
      .Option(impl.firewallSubnetRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Route.wrap(item)
        }.toList
      )
    override val internetGatewayId: Option[ResourceId] = scala
      .Option(impl.internetGatewayId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val currentInternetGatewayRouteTable: Option[ResourceId] = scala
      .Option(impl.currentInternetGatewayRouteTable())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val internetGatewayRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]] = scala
      .Option(impl.internetGatewayRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Route.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation
  ): zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.ReadOnly =
    new Wrapper(impl)
}
