package zio.aws.fms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.fms.model.primitives.{
  StatelessRuleGroupPriority,
  ResourceId,
  NetworkFirewallResourceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StatelessRuleGroup(
    ruleGroupName: Option[NetworkFirewallResourceName] = None,
    resourceId: Option[ResourceId] = None,
    priority: Option[StatelessRuleGroupPriority] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.StatelessRuleGroup = {
    import StatelessRuleGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.StatelessRuleGroup
      .builder()
      .optionallyWith(
        ruleGroupName.map(value =>
          NetworkFirewallResourceName.unwrap(value): java.lang.String
        )
      )(_.ruleGroupName)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        priority.map(value => StatelessRuleGroupPriority.unwrap(value): Integer)
      )(_.priority)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.StatelessRuleGroup.ReadOnly =
    zio.aws.fms.model.StatelessRuleGroup.wrap(buildAwsValue())
}
object StatelessRuleGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.StatelessRuleGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.StatelessRuleGroup =
      zio.aws.fms.model.StatelessRuleGroup(
        ruleGroupName.map(value => value),
        resourceId.map(value => value),
        priority.map(value => value)
      )
    def ruleGroupName: Option[NetworkFirewallResourceName]
    def resourceId: Option[ResourceId]
    def priority: Option[StatelessRuleGroupPriority]
    def getRuleGroupName: ZIO[Any, AwsError, NetworkFirewallResourceName] =
      AwsError.unwrapOptionField("ruleGroupName", ruleGroupName)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getPriority: ZIO[Any, AwsError, StatelessRuleGroupPriority] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.StatelessRuleGroup
  ) extends zio.aws.fms.model.StatelessRuleGroup.ReadOnly {
    override val ruleGroupName: Option[NetworkFirewallResourceName] = scala
      .Option(impl.ruleGroupName())
      .map(value =>
        zio.aws.fms.model.primitives.NetworkFirewallResourceName(value)
      )
    override val resourceId: Option[ResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val priority: Option[StatelessRuleGroupPriority] = scala
      .Option(impl.priority())
      .map(value =>
        zio.aws.fms.model.primitives.StatelessRuleGroupPriority(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.StatelessRuleGroup
  ): zio.aws.fms.model.StatelessRuleGroup.ReadOnly = new Wrapper(impl)
}
