package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  LengthBoundedString,
  AWSAccountId,
  ResourceType,
  PolicyId,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ViolationDetail(
    policyId: PolicyId,
    memberAccount: AWSAccountId,
    resourceId: ResourceId,
    resourceType: ResourceType,
    resourceViolations: Iterable[zio.aws.fms.model.ResourceViolation],
    resourceTags: Option[Iterable[zio.aws.fms.model.Tag]] = None,
    resourceDescription: Option[LengthBoundedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ViolationDetail = {
    import ViolationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ViolationDetail
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .memberAccount(AWSAccountId.unwrap(memberAccount): java.lang.String)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .resourceViolations(resourceViolations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .optionallyWith(
        resourceDescription.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.resourceDescription)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ViolationDetail.ReadOnly =
    zio.aws.fms.model.ViolationDetail.wrap(buildAwsValue())
}
object ViolationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ViolationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ViolationDetail =
      zio.aws.fms.model.ViolationDetail(
        policyId,
        memberAccount,
        resourceId,
        resourceType,
        resourceViolations.map { item =>
          item.asEditable
        },
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceDescription.map(value => value)
      )
    def policyId: PolicyId
    def memberAccount: AWSAccountId
    def resourceId: ResourceId
    def resourceType: ResourceType
    def resourceViolations: List[zio.aws.fms.model.ResourceViolation.ReadOnly]
    def resourceTags: Option[List[zio.aws.fms.model.Tag.ReadOnly]]
    def resourceDescription: Option[LengthBoundedString]
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
    def getMemberAccount: ZIO[Any, Nothing, AWSAccountId] =
      ZIO.succeed(memberAccount)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
    def getResourceViolations: ZIO[Any, Nothing, List[
      zio.aws.fms.model.ResourceViolation.ReadOnly
    ]] = ZIO.succeed(resourceViolations)
    def getResourceTags
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getResourceDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("resourceDescription", resourceDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ViolationDetail
  ) extends zio.aws.fms.model.ViolationDetail.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.fms.model.primitives.PolicyId(impl.policyId())
    override val memberAccount: AWSAccountId =
      zio.aws.fms.model.primitives.AWSAccountId(impl.memberAccount())
    override val resourceId: ResourceId =
      zio.aws.fms.model.primitives.ResourceId(impl.resourceId())
    override val resourceType: ResourceType =
      zio.aws.fms.model.primitives.ResourceType(impl.resourceType())
    override val resourceViolations
        : List[zio.aws.fms.model.ResourceViolation.ReadOnly] = impl
      .resourceViolations()
      .asScala
      .map { item =>
        zio.aws.fms.model.ResourceViolation.wrap(item)
      }
      .toList
    override val resourceTags: Option[List[zio.aws.fms.model.Tag.ReadOnly]] =
      scala
        .Option(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Tag.wrap(item)
          }.toList
        )
    override val resourceDescription: Option[LengthBoundedString] = scala
      .Option(impl.resourceDescription())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ViolationDetail
  ): zio.aws.fms.model.ViolationDetail.ReadOnly = new Wrapper(impl)
}
