package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{LengthBoundedString, ResourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ActionTarget(
    resourceId: Option[ResourceId] = None,
    description: Option[LengthBoundedString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ActionTarget = {
    import ActionTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ActionTarget
      .builder()
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ActionTarget.ReadOnly =
    zio.aws.fms.model.ActionTarget.wrap(buildAwsValue())
}
object ActionTarget {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.ActionTarget] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ActionTarget =
      zio.aws.fms.model.ActionTarget(
        resourceId.map(value => value),
        description.map(value => value)
      )
    def resourceId: Option[ResourceId]
    def description: Option[LengthBoundedString]
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ActionTarget
  ) extends zio.aws.fms.model.ActionTarget.ReadOnly {
    override val resourceId: Option[ResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val description: Option[LengthBoundedString] = scala
      .Option(impl.description())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ActionTarget
  ): zio.aws.fms.model.ActionTarget.ReadOnly = new Wrapper(impl)
}
