package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  PreviousListVersion,
  UpdateToken,
  TimeStamp,
  ListId,
  ResourceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AppsListData(
    listId: Option[ListId] = None,
    listName: ResourceName,
    listUpdateToken: Option[UpdateToken] = None,
    createTime: Option[TimeStamp] = None,
    lastUpdateTime: Option[TimeStamp] = None,
    appsList: Iterable[zio.aws.fms.model.App],
    previousAppsList: Option[
      Map[PreviousListVersion, Iterable[zio.aws.fms.model.App]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.AppsListData = {
    import AppsListData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.AppsListData
      .builder()
      .optionallyWith(
        listId.map(value => ListId.unwrap(value): java.lang.String)
      )(_.listId)
      .listName(ResourceName.unwrap(listName): java.lang.String)
      .optionallyWith(
        listUpdateToken.map(value =>
          UpdateToken.unwrap(value): java.lang.String
        )
      )(_.listUpdateToken)
      .optionallyWith(
        createTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(
        lastUpdateTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .appsList(appsList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        previousAppsList.map(value =>
          value
            .map({ case (key, value) =>
              (PreviousListVersion.unwrap(key): java.lang.String) -> value.map {
                item =>
                  item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.previousAppsList)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.AppsListData.ReadOnly =
    zio.aws.fms.model.AppsListData.wrap(buildAwsValue())
}
object AppsListData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.AppsListData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.AppsListData =
      zio.aws.fms.model.AppsListData(
        listId.map(value => value),
        listName,
        listUpdateToken.map(value => value),
        createTime.map(value => value),
        lastUpdateTime.map(value => value),
        appsList.map { item =>
          item.asEditable
        },
        previousAppsList.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        )
      )
    def listId: Option[ListId]
    def listName: ResourceName
    def listUpdateToken: Option[UpdateToken]
    def createTime: Option[TimeStamp]
    def lastUpdateTime: Option[TimeStamp]
    def appsList: List[zio.aws.fms.model.App.ReadOnly]
    def previousAppsList
        : Option[Map[PreviousListVersion, List[zio.aws.fms.model.App.ReadOnly]]]
    def getListId: ZIO[Any, AwsError, ListId] =
      AwsError.unwrapOptionField("listId", listId)
    def getListName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(listName)
    def getListUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("listUpdateToken", listUpdateToken)
    def getCreateTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastUpdateTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getAppsList: ZIO[Any, Nothing, List[zio.aws.fms.model.App.ReadOnly]] =
      ZIO.succeed(appsList)
    def getPreviousAppsList: ZIO[Any, AwsError, Map[PreviousListVersion, List[
      zio.aws.fms.model.App.ReadOnly
    ]]] = AwsError.unwrapOptionField("previousAppsList", previousAppsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.AppsListData
  ) extends zio.aws.fms.model.AppsListData.ReadOnly {
    override val listId: Option[ListId] = scala
      .Option(impl.listId())
      .map(value => zio.aws.fms.model.primitives.ListId(value))
    override val listName: ResourceName =
      zio.aws.fms.model.primitives.ResourceName(impl.listName())
    override val listUpdateToken: Option[UpdateToken] = scala
      .Option(impl.listUpdateToken())
      .map(value => zio.aws.fms.model.primitives.UpdateToken(value))
    override val createTime: Option[TimeStamp] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val lastUpdateTime: Option[TimeStamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val appsList: List[zio.aws.fms.model.App.ReadOnly] = impl
      .appsList()
      .asScala
      .map { item =>
        zio.aws.fms.model.App.wrap(item)
      }
      .toList
    override val previousAppsList: Option[
      Map[PreviousListVersion, List[zio.aws.fms.model.App.ReadOnly]]
    ] = scala
      .Option(impl.previousAppsList())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.fms.model.primitives
              .PreviousListVersion(key) -> value.asScala.map { item =>
              zio.aws.fms.model.App.wrap(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.AppsListData
  ): zio.aws.fms.model.AppsListData.ReadOnly = new Wrapper(impl)
}
