package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{ResourceName, ListId, ResourceArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AppsListDataSummary(
    listArn: Option[ResourceArn] = None,
    listId: Option[ListId] = None,
    listName: Option[ResourceName] = None,
    appsList: Option[Iterable[zio.aws.fms.model.App]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.AppsListDataSummary = {
    import AppsListDataSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.AppsListDataSummary
      .builder()
      .optionallyWith(
        listArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.listArn)
      .optionallyWith(
        listId.map(value => ListId.unwrap(value): java.lang.String)
      )(_.listId)
      .optionallyWith(
        listName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.listName)
      .optionallyWith(
        appsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appsList)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.AppsListDataSummary.ReadOnly =
    zio.aws.fms.model.AppsListDataSummary.wrap(buildAwsValue())
}
object AppsListDataSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.AppsListDataSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.AppsListDataSummary =
      zio.aws.fms.model.AppsListDataSummary(
        listArn.map(value => value),
        listId.map(value => value),
        listName.map(value => value),
        appsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def listArn: Option[ResourceArn]
    def listId: Option[ListId]
    def listName: Option[ResourceName]
    def appsList: Option[List[zio.aws.fms.model.App.ReadOnly]]
    def getListArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("listArn", listArn)
    def getListId: ZIO[Any, AwsError, ListId] =
      AwsError.unwrapOptionField("listId", listId)
    def getListName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("listName", listName)
    def getAppsList: ZIO[Any, AwsError, List[zio.aws.fms.model.App.ReadOnly]] =
      AwsError.unwrapOptionField("appsList", appsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.AppsListDataSummary
  ) extends zio.aws.fms.model.AppsListDataSummary.ReadOnly {
    override val listArn: Option[ResourceArn] = scala
      .Option(impl.listArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
    override val listId: Option[ListId] = scala
      .Option(impl.listId())
      .map(value => zio.aws.fms.model.primitives.ListId(value))
    override val listName: Option[ResourceName] = scala
      .Option(impl.listName())
      .map(value => zio.aws.fms.model.primitives.ResourceName(value))
    override val appsList: Option[List[zio.aws.fms.model.App.ReadOnly]] = scala
      .Option(impl.appsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.App.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.AppsListDataSummary
  ): zio.aws.fms.model.AppsListDataSummary.ReadOnly = new Wrapper(impl)
}
