package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ViolationTarget
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AwsEc2InstanceViolation(
    violationTarget: Option[ViolationTarget] = None,
    awsEc2NetworkInterfaceViolations: Option[
      Iterable[zio.aws.fms.model.AwsEc2NetworkInterfaceViolation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.AwsEc2InstanceViolation = {
    import AwsEc2InstanceViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.AwsEc2InstanceViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        awsEc2NetworkInterfaceViolations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.awsEc2NetworkInterfaceViolations)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.AwsEc2InstanceViolation.ReadOnly =
    zio.aws.fms.model.AwsEc2InstanceViolation.wrap(buildAwsValue())
}
object AwsEc2InstanceViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.AwsEc2InstanceViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.AwsEc2InstanceViolation =
      zio.aws.fms.model.AwsEc2InstanceViolation(
        violationTarget.map(value => value),
        awsEc2NetworkInterfaceViolations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def violationTarget: Option[ViolationTarget]
    def awsEc2NetworkInterfaceViolations: Option[
      List[zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly]
    ]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getAwsEc2NetworkInterfaceViolations: ZIO[Any, AwsError, List[
      zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "awsEc2NetworkInterfaceViolations",
      awsEc2NetworkInterfaceViolations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.AwsEc2InstanceViolation
  ) extends zio.aws.fms.model.AwsEc2InstanceViolation.ReadOnly {
    override val violationTarget: Option[ViolationTarget] = scala
      .Option(impl.violationTarget())
      .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val awsEc2NetworkInterfaceViolations: Option[
      List[zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly]
    ] = scala
      .Option(impl.awsEc2NetworkInterfaceViolations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.AwsEc2InstanceViolation
  ): zio.aws.fms.model.AwsEc2InstanceViolation.ReadOnly = new Wrapper(impl)
}
