package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  LengthBoundedString,
  ResourceType,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ComplianceViolator(
    resourceId: Option[ResourceId] = None,
    violationReason: Option[zio.aws.fms.model.ViolationReason] = None,
    resourceType: Option[ResourceType] = None,
    metadata: Option[Map[LengthBoundedString, LengthBoundedString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ComplianceViolator = {
    import ComplianceViolator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ComplianceViolator
      .builder()
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(violationReason.map(value => value.unwrap))(
        _.violationReason
      )
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (LengthBoundedString
                .unwrap(key): java.lang.String) -> (LengthBoundedString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ComplianceViolator.ReadOnly =
    zio.aws.fms.model.ComplianceViolator.wrap(buildAwsValue())
}
object ComplianceViolator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ComplianceViolator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ComplianceViolator =
      zio.aws.fms.model.ComplianceViolator(
        resourceId.map(value => value),
        violationReason.map(value => value),
        resourceType.map(value => value),
        metadata.map(value => value)
      )
    def resourceId: Option[ResourceId]
    def violationReason: Option[zio.aws.fms.model.ViolationReason]
    def resourceType: Option[ResourceType]
    def metadata: Option[Map[LengthBoundedString, LengthBoundedString]]
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getViolationReason
        : ZIO[Any, AwsError, zio.aws.fms.model.ViolationReason] =
      AwsError.unwrapOptionField("violationReason", violationReason)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getMetadata
        : ZIO[Any, AwsError, Map[LengthBoundedString, LengthBoundedString]] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ComplianceViolator
  ) extends zio.aws.fms.model.ComplianceViolator.ReadOnly {
    override val resourceId: Option[ResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val violationReason: Option[zio.aws.fms.model.ViolationReason] =
      scala
        .Option(impl.violationReason())
        .map(value => zio.aws.fms.model.ViolationReason.wrap(value))
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.fms.model.primitives.ResourceType(value))
    override val metadata
        : Option[Map[LengthBoundedString, LengthBoundedString]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.fms.model.primitives.LengthBoundedString(
              key
            ) -> zio.aws.fms.model.primitives.LengthBoundedString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ComplianceViolator
  ): zio.aws.fms.model.ComplianceViolator.ReadOnly = new Wrapper(impl)
}
