package zio.aws.fms.model
import scala.jdk.CollectionConverters.*
sealed trait FirewallDeploymentModel {
  def unwrap: software.amazon.awssdk.services.fms.model.FirewallDeploymentModel
}
object FirewallDeploymentModel {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.FirewallDeploymentModel
  ): zio.aws.fms.model.FirewallDeploymentModel = value match {
    case software.amazon.awssdk.services.fms.model.FirewallDeploymentModel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.FirewallDeploymentModel.CENTRALIZED =>
      val r = CENTRALIZED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fms.model.FirewallDeploymentModel {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.FirewallDeploymentModel =
      software.amazon.awssdk.services.fms.model.FirewallDeploymentModel.UNKNOWN_TO_SDK_VERSION
  }
  case object CENTRALIZED extends zio.aws.fms.model.FirewallDeploymentModel {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.FirewallDeploymentModel =
      software.amazon.awssdk.services.fms.model.FirewallDeploymentModel.CENTRALIZED
  }
}
