package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetNotificationChannelResponse(
    snsTopicArn: Option[ResourceArn] = None,
    snsRoleName: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetNotificationChannelResponse = {
    import GetNotificationChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetNotificationChannelResponse
      .builder()
      .optionallyWith(
        snsTopicArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        snsRoleName.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.snsRoleName)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetNotificationChannelResponse.ReadOnly =
    zio.aws.fms.model.GetNotificationChannelResponse.wrap(buildAwsValue())
}
object GetNotificationChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetNotificationChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetNotificationChannelResponse =
      zio.aws.fms.model.GetNotificationChannelResponse(
        snsTopicArn.map(value => value),
        snsRoleName.map(value => value)
      )
    def snsTopicArn: Option[ResourceArn]
    def snsRoleName: Option[ResourceArn]
    def getSnsTopicArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSnsRoleName: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("snsRoleName", snsRoleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetNotificationChannelResponse
  ) extends zio.aws.fms.model.GetNotificationChannelResponse.ReadOnly {
    override val snsTopicArn: Option[ResourceArn] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
    override val snsRoleName: Option[ResourceArn] = scala
      .Option(impl.snsRoleName())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetNotificationChannelResponse
  ): zio.aws.fms.model.GetNotificationChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
