package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ViolationTarget
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallPolicyModifiedViolation(
    violationTarget: Option[ViolationTarget] = None,
    currentPolicyDescription: Option[
      zio.aws.fms.model.NetworkFirewallPolicyDescription
    ] = None,
    expectedPolicyDescription: Option[
      zio.aws.fms.model.NetworkFirewallPolicyDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation = {
    import NetworkFirewallPolicyModifiedViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        currentPolicyDescription.map(value => value.buildAwsValue())
      )(_.currentPolicyDescription)
      .optionallyWith(
        expectedPolicyDescription.map(value => value.buildAwsValue())
      )(_.expectedPolicyDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallPolicyModifiedViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation =
      zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation(
        violationTarget.map(value => value),
        currentPolicyDescription.map(value => value.asEditable),
        expectedPolicyDescription.map(value => value.asEditable)
      )
    def violationTarget: Option[ViolationTarget]
    def currentPolicyDescription
        : Option[zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly]
    def expectedPolicyDescription
        : Option[zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getCurrentPolicyDescription: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "currentPolicyDescription",
      currentPolicyDescription
    )
    def getExpectedPolicyDescription: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "expectedPolicyDescription",
      expectedPolicyDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation
  ) extends zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly {
    override val violationTarget: Option[ViolationTarget] = scala
      .Option(impl.violationTarget())
      .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val currentPolicyDescription
        : Option[zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly] =
      scala
        .Option(impl.currentPolicyDescription())
        .map(value =>
          zio.aws.fms.model.NetworkFirewallPolicyDescription.wrap(value)
        )
    override val expectedPolicyDescription
        : Option[zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly] =
      scala
        .Option(impl.expectedPolicyDescription())
        .map(value =>
          zio.aws.fms.model.NetworkFirewallPolicyDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation
  ): zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly =
    new Wrapper(impl)
}
