package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallUnexpectedGatewayRoutesViolation(
    gatewayId: Option[ResourceId] = None,
    violatingRoutes: Option[Iterable[zio.aws.fms.model.Route]] = None,
    routeTableId: Option[ResourceId] = None,
    vpcId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation = {
    import NetworkFirewallUnexpectedGatewayRoutesViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
      .builder()
      .optionallyWith(
        gatewayId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(
        violatingRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violatingRoutes)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallUnexpectedGatewayRoutesViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation =
      zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation(
        gatewayId.map(value => value),
        violatingRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        routeTableId.map(value => value),
        vpcId.map(value => value)
      )
    def gatewayId: Option[ResourceId]
    def violatingRoutes: Option[List[zio.aws.fms.model.Route.ReadOnly]]
    def routeTableId: Option[ResourceId]
    def vpcId: Option[ResourceId]
    def getGatewayId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getViolatingRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("violatingRoutes", violatingRoutes)
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
  ) extends zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly {
    override val gatewayId: Option[ResourceId] = scala
      .Option(impl.gatewayId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val violatingRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]] = scala
      .Option(impl.violatingRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Route.wrap(item)
        }.toList
      )
    override val routeTableId: Option[ResourceId] = scala
      .Option(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val vpcId: Option[ResourceId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
  ): zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly =
    new Wrapper(impl)
}
