package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.LengthBoundedString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PossibleRemediationAction(
    description: Option[LengthBoundedString] = None,
    orderedRemediationActions: Iterable[
      zio.aws.fms.model.RemediationActionWithOrder
    ],
    isDefaultAction: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PossibleRemediationAction = {
    import PossibleRemediationAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PossibleRemediationAction
      .builder()
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .orderedRemediationActions(orderedRemediationActions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(isDefaultAction.map(value => value: java.lang.Boolean))(
        _.isDefaultAction
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PossibleRemediationAction.ReadOnly =
    zio.aws.fms.model.PossibleRemediationAction.wrap(buildAwsValue())
}
object PossibleRemediationAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.PossibleRemediationAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PossibleRemediationAction =
      zio.aws.fms.model.PossibleRemediationAction(
        description.map(value => value),
        orderedRemediationActions.map { item =>
          item.asEditable
        },
        isDefaultAction.map(value => value)
      )
    def description: Option[LengthBoundedString]
    def orderedRemediationActions
        : List[zio.aws.fms.model.RemediationActionWithOrder.ReadOnly]
    def isDefaultAction: Option[Boolean]
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
    def getOrderedRemediationActions: ZIO[Any, Nothing, List[
      zio.aws.fms.model.RemediationActionWithOrder.ReadOnly
    ]] = ZIO.succeed(orderedRemediationActions)
    def getIsDefaultAction: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefaultAction", isDefaultAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PossibleRemediationAction
  ) extends zio.aws.fms.model.PossibleRemediationAction.ReadOnly {
    override val description: Option[LengthBoundedString] = scala
      .Option(impl.description())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val orderedRemediationActions
        : List[zio.aws.fms.model.RemediationActionWithOrder.ReadOnly] = impl
      .orderedRemediationActions()
      .asScala
      .map { item =>
        zio.aws.fms.model.RemediationActionWithOrder.wrap(item)
      }
      .toList
    override val isDefaultAction: Option[Boolean] =
      scala.Option(impl.isDefaultAction()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PossibleRemediationAction
  ): zio.aws.fms.model.PossibleRemediationAction.ReadOnly = new Wrapper(impl)
}
