package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  Protocol,
  ResourceName,
  ListId,
  ResourceArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ProtocolsListDataSummary(
    listArn: Option[ResourceArn] = None,
    listId: Option[ListId] = None,
    listName: Option[ResourceName] = None,
    protocolsList: Option[Iterable[Protocol]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ProtocolsListDataSummary = {
    import ProtocolsListDataSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ProtocolsListDataSummary
      .builder()
      .optionallyWith(
        listArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.listArn)
      .optionallyWith(
        listId.map(value => ListId.unwrap(value): java.lang.String)
      )(_.listId)
      .optionallyWith(
        listName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.listName)
      .optionallyWith(
        protocolsList.map(value =>
          value.map { item =>
            Protocol.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.protocolsList)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly =
    zio.aws.fms.model.ProtocolsListDataSummary.wrap(buildAwsValue())
}
object ProtocolsListDataSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ProtocolsListDataSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ProtocolsListDataSummary =
      zio.aws.fms.model.ProtocolsListDataSummary(
        listArn.map(value => value),
        listId.map(value => value),
        listName.map(value => value),
        protocolsList.map(value => value)
      )
    def listArn: Option[ResourceArn]
    def listId: Option[ListId]
    def listName: Option[ResourceName]
    def protocolsList: Option[List[Protocol]]
    def getListArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("listArn", listArn)
    def getListId: ZIO[Any, AwsError, ListId] =
      AwsError.unwrapOptionField("listId", listId)
    def getListName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("listName", listName)
    def getProtocolsList: ZIO[Any, AwsError, List[Protocol]] =
      AwsError.unwrapOptionField("protocolsList", protocolsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ProtocolsListDataSummary
  ) extends zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly {
    override val listArn: Option[ResourceArn] = scala
      .Option(impl.listArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
    override val listId: Option[ListId] = scala
      .Option(impl.listId())
      .map(value => zio.aws.fms.model.primitives.ListId(value))
    override val listName: Option[ResourceName] = scala
      .Option(impl.listName())
      .map(value => zio.aws.fms.model.primitives.ResourceName(value))
    override val protocolsList: Option[List[Protocol]] = scala
      .Option(impl.protocolsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.primitives.Protocol(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ProtocolsListDataSummary
  ): zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly = new Wrapper(impl)
}
