package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  IPPortNumber,
  LengthBoundedString,
  ResourceId,
  CIDR
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SecurityGroupRuleDescription(
    ipv4Range: Option[CIDR] = None,
    ipv6Range: Option[CIDR] = None,
    prefixListId: Option[ResourceId] = None,
    protocol: Option[LengthBoundedString] = None,
    fromPort: Option[IPPortNumber] = None,
    toPort: Option[IPPortNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.SecurityGroupRuleDescription = {
    import SecurityGroupRuleDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.SecurityGroupRuleDescription
      .builder()
      .optionallyWith(
        ipv4Range.map(value => CIDR.unwrap(value): java.lang.String)
      )(_.ipv4Range)
      .optionallyWith(
        ipv6Range.map(value => CIDR.unwrap(value): java.lang.String)
      )(_.ipv6Range)
      .optionallyWith(
        prefixListId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.prefixListId)
      .optionallyWith(
        protocol.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.protocol)
      .optionallyWith(
        fromPort.map(value => IPPortNumber.unwrap(value): java.lang.Long)
      )(_.fromPort)
      .optionallyWith(
        toPort.map(value => IPPortNumber.unwrap(value): java.lang.Long)
      )(_.toPort)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.SecurityGroupRuleDescription.ReadOnly =
    zio.aws.fms.model.SecurityGroupRuleDescription.wrap(buildAwsValue())
}
object SecurityGroupRuleDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.SecurityGroupRuleDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.SecurityGroupRuleDescription =
      zio.aws.fms.model.SecurityGroupRuleDescription(
        ipv4Range.map(value => value),
        ipv6Range.map(value => value),
        prefixListId.map(value => value),
        protocol.map(value => value),
        fromPort.map(value => value),
        toPort.map(value => value)
      )
    def ipv4Range: Option[CIDR]
    def ipv6Range: Option[CIDR]
    def prefixListId: Option[ResourceId]
    def protocol: Option[LengthBoundedString]
    def fromPort: Option[IPPortNumber]
    def toPort: Option[IPPortNumber]
    def getIpv4Range: ZIO[Any, AwsError, CIDR] =
      AwsError.unwrapOptionField("ipv4Range", ipv4Range)
    def getIpv6Range: ZIO[Any, AwsError, CIDR] =
      AwsError.unwrapOptionField("ipv6Range", ipv6Range)
    def getPrefixListId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getProtocol: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getFromPort: ZIO[Any, AwsError, IPPortNumber] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, IPPortNumber] =
      AwsError.unwrapOptionField("toPort", toPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.SecurityGroupRuleDescription
  ) extends zio.aws.fms.model.SecurityGroupRuleDescription.ReadOnly {
    override val ipv4Range: Option[CIDR] = scala
      .Option(impl.ipv4Range())
      .map(value => zio.aws.fms.model.primitives.CIDR(value))
    override val ipv6Range: Option[CIDR] = scala
      .Option(impl.ipv6Range())
      .map(value => zio.aws.fms.model.primitives.CIDR(value))
    override val prefixListId: Option[ResourceId] = scala
      .Option(impl.prefixListId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val protocol: Option[LengthBoundedString] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val fromPort: Option[IPPortNumber] = scala
      .Option(impl.fromPort())
      .map(value => zio.aws.fms.model.primitives.IPPortNumber(value))
    override val toPort: Option[IPPortNumber] = scala
      .Option(impl.toPort())
      .map(value => zio.aws.fms.model.primitives.IPPortNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.SecurityGroupRuleDescription
  ): zio.aws.fms.model.SecurityGroupRuleDescription.ReadOnly = new Wrapper(impl)
}
