package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ManagedServiceData
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SecurityServicePolicyData(
    `type`: zio.aws.fms.model.SecurityServiceType,
    managedServiceData: Option[ManagedServiceData] = None,
    policyOption: Option[zio.aws.fms.model.PolicyOption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.SecurityServicePolicyData = {
    import SecurityServicePolicyData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.SecurityServicePolicyData
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        managedServiceData.map(value =>
          ManagedServiceData.unwrap(value): java.lang.String
        )
      )(_.managedServiceData)
      .optionallyWith(policyOption.map(value => value.buildAwsValue()))(
        _.policyOption
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.SecurityServicePolicyData.ReadOnly =
    zio.aws.fms.model.SecurityServicePolicyData.wrap(buildAwsValue())
}
object SecurityServicePolicyData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.SecurityServicePolicyData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.SecurityServicePolicyData =
      zio.aws.fms.model.SecurityServicePolicyData(
        `type`,
        managedServiceData.map(value => value),
        policyOption.map(value => value.asEditable)
      )
    def `type`: zio.aws.fms.model.SecurityServiceType
    def managedServiceData: Option[ManagedServiceData]
    def policyOption: Option[zio.aws.fms.model.PolicyOption.ReadOnly]
    def getType: ZIO[Any, Nothing, zio.aws.fms.model.SecurityServiceType] =
      ZIO.succeed(`type`)
    def getManagedServiceData: ZIO[Any, AwsError, ManagedServiceData] =
      AwsError.unwrapOptionField("managedServiceData", managedServiceData)
    def getPolicyOption
        : ZIO[Any, AwsError, zio.aws.fms.model.PolicyOption.ReadOnly] =
      AwsError.unwrapOptionField("policyOption", policyOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.SecurityServicePolicyData
  ) extends zio.aws.fms.model.SecurityServicePolicyData.ReadOnly {
    override val `type`: zio.aws.fms.model.SecurityServiceType =
      zio.aws.fms.model.SecurityServiceType.wrap(impl.`type`())
    override val managedServiceData: Option[ManagedServiceData] = scala
      .Option(impl.managedServiceData())
      .map(value => zio.aws.fms.model.primitives.ManagedServiceData(value))
    override val policyOption: Option[zio.aws.fms.model.PolicyOption.ReadOnly] =
      scala
        .Option(impl.policyOption())
        .map(value => zio.aws.fms.model.PolicyOption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.SecurityServicePolicyData
  ): zio.aws.fms.model.SecurityServicePolicyData.ReadOnly = new Wrapper(impl)
}
