package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{LengthBoundedString, ViolationTarget}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AwsVPCSecurityGroupViolation(
    violationTarget: Optional[ViolationTarget] = Optional.Absent,
    violationTargetDescription: Optional[LengthBoundedString] = Optional.Absent,
    partialMatches: Optional[Iterable[zio.aws.fms.model.PartialMatch]] =
      Optional.Absent,
    possibleSecurityGroupRemediationActions: Optional[
      Iterable[zio.aws.fms.model.SecurityGroupRemediationAction]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.AwsVPCSecurityGroupViolation = {
    import AwsVPCSecurityGroupViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.AwsVPCSecurityGroupViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        violationTargetDescription.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.violationTargetDescription)
      .optionallyWith(
        partialMatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partialMatches)
      .optionallyWith(
        possibleSecurityGroupRemediationActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.possibleSecurityGroupRemediationActions)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.AwsVPCSecurityGroupViolation.ReadOnly =
    zio.aws.fms.model.AwsVPCSecurityGroupViolation.wrap(buildAwsValue())
}
object AwsVPCSecurityGroupViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.AwsVPCSecurityGroupViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.AwsVPCSecurityGroupViolation =
      zio.aws.fms.model.AwsVPCSecurityGroupViolation(
        violationTarget.map(value => value),
        violationTargetDescription.map(value => value),
        partialMatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        possibleSecurityGroupRemediationActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def violationTarget: Optional[ViolationTarget]
    def violationTargetDescription: Optional[LengthBoundedString]
    def partialMatches: Optional[List[zio.aws.fms.model.PartialMatch.ReadOnly]]
    def possibleSecurityGroupRemediationActions: Optional[
      List[zio.aws.fms.model.SecurityGroupRemediationAction.ReadOnly]
    ]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getViolationTargetDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "violationTargetDescription",
        violationTargetDescription
      )
    def getPartialMatches
        : ZIO[Any, AwsError, List[zio.aws.fms.model.PartialMatch.ReadOnly]] =
      AwsError.unwrapOptionField("partialMatches", partialMatches)
    def getPossibleSecurityGroupRemediationActions: ZIO[Any, AwsError, List[
      zio.aws.fms.model.SecurityGroupRemediationAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "possibleSecurityGroupRemediationActions",
      possibleSecurityGroupRemediationActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.AwsVPCSecurityGroupViolation
  ) extends zio.aws.fms.model.AwsVPCSecurityGroupViolation.ReadOnly {
    override val violationTarget: Optional[ViolationTarget] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationTarget())
        .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val violationTargetDescription: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationTargetDescription())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val partialMatches
        : Optional[List[zio.aws.fms.model.PartialMatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partialMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.PartialMatch.wrap(item)
          }.toList
        )
    override val possibleSecurityGroupRemediationActions: Optional[
      List[zio.aws.fms.model.SecurityGroupRemediationAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.possibleSecurityGroupRemediationActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.SecurityGroupRemediationAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.AwsVPCSecurityGroupViolation
  ): zio.aws.fms.model.AwsVPCSecurityGroupViolation.ReadOnly = new Wrapper(impl)
}
