package zio.aws.fms.model
import scala.jdk.CollectionConverters.*
sealed trait DependentServiceName {
  def unwrap: software.amazon.awssdk.services.fms.model.DependentServiceName
}
object DependentServiceName {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.DependentServiceName
  ): zio.aws.fms.model.DependentServiceName = value match {
    case software.amazon.awssdk.services.fms.model.DependentServiceName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.DependentServiceName.AWSCONFIG =>
      val r = AWSCONFIG
      r
    case software.amazon.awssdk.services.fms.model.DependentServiceName.AWSWAF =>
      val r = AWSWAF
      r
    case software.amazon.awssdk.services.fms.model.DependentServiceName.AWSSHIELD_ADVANCED =>
      val r = AWSSHIELD_ADVANCED
      r
    case software.amazon.awssdk.services.fms.model.DependentServiceName.AWSVPC =>
      val r = AWSVPC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fms.model.DependentServiceName {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.DependentServiceName =
      software.amazon.awssdk.services.fms.model.DependentServiceName.UNKNOWN_TO_SDK_VERSION
  }
  case object AWSCONFIG extends zio.aws.fms.model.DependentServiceName {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.DependentServiceName =
      software.amazon.awssdk.services.fms.model.DependentServiceName.AWSCONFIG
  }
  case object AWSWAF extends zio.aws.fms.model.DependentServiceName {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.DependentServiceName =
      software.amazon.awssdk.services.fms.model.DependentServiceName.AWSWAF
  }
  case object AWSSHIELD_ADVANCED
      extends zio.aws.fms.model.DependentServiceName {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.DependentServiceName =
      software.amazon.awssdk.services.fms.model.DependentServiceName.AWSSHIELD_ADVANCED
  }
  case object AWSVPC extends zio.aws.fms.model.DependentServiceName {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.DependentServiceName =
      software.amazon.awssdk.services.fms.model.DependentServiceName.AWSVPC
  }
}
