package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{LengthBoundedString, ViolationTarget}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DnsDuplicateRuleGroupViolation(
    violationTarget: Optional[ViolationTarget] = Optional.Absent,
    violationTargetDescription: Optional[LengthBoundedString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.DnsDuplicateRuleGroupViolation = {
    import DnsDuplicateRuleGroupViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.DnsDuplicateRuleGroupViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        violationTargetDescription.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.violationTargetDescription)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.DnsDuplicateRuleGroupViolation.ReadOnly =
    zio.aws.fms.model.DnsDuplicateRuleGroupViolation.wrap(buildAwsValue())
}
object DnsDuplicateRuleGroupViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.DnsDuplicateRuleGroupViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.DnsDuplicateRuleGroupViolation =
      zio.aws.fms.model.DnsDuplicateRuleGroupViolation(
        violationTarget.map(value => value),
        violationTargetDescription.map(value => value)
      )
    def violationTarget: Optional[ViolationTarget]
    def violationTargetDescription: Optional[LengthBoundedString]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getViolationTargetDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "violationTargetDescription",
        violationTargetDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.DnsDuplicateRuleGroupViolation
  ) extends zio.aws.fms.model.DnsDuplicateRuleGroupViolation.ReadOnly {
    override val violationTarget: Optional[ViolationTarget] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationTarget())
        .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val violationTargetDescription: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationTargetDescription())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.DnsDuplicateRuleGroupViolation
  ): zio.aws.fms.model.DnsDuplicateRuleGroupViolation.ReadOnly = new Wrapper(
    impl
  )
}
