package zio.aws.fms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.{
  PolicyId,
  DnsRuleGroupPriority,
  LengthBoundedString,
  ViolationTarget
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DnsRuleGroupPriorityConflictViolation(
    violationTarget: Optional[ViolationTarget] = Optional.Absent,
    violationTargetDescription: Optional[LengthBoundedString] = Optional.Absent,
    conflictingPriority: Optional[DnsRuleGroupPriority] = Optional.Absent,
    conflictingPolicyId: Optional[PolicyId] = Optional.Absent,
    unavailablePriorities: Optional[Iterable[DnsRuleGroupPriority]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.DnsRuleGroupPriorityConflictViolation = {
    import DnsRuleGroupPriorityConflictViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.DnsRuleGroupPriorityConflictViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        violationTargetDescription.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.violationTargetDescription)
      .optionallyWith(
        conflictingPriority.map(value =>
          DnsRuleGroupPriority.unwrap(value): Integer
        )
      )(_.conflictingPriority)
      .optionallyWith(
        conflictingPolicyId.map(value =>
          PolicyId.unwrap(value): java.lang.String
        )
      )(_.conflictingPolicyId)
      .optionallyWith(
        unavailablePriorities.map(value =>
          value.map { item =>
            DnsRuleGroupPriority.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.unavailablePriorities)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.ReadOnly =
    zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation
      .wrap(buildAwsValue())
}
object DnsRuleGroupPriorityConflictViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.DnsRuleGroupPriorityConflictViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation =
      zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation(
        violationTarget.map(value => value),
        violationTargetDescription.map(value => value),
        conflictingPriority.map(value => value),
        conflictingPolicyId.map(value => value),
        unavailablePriorities.map(value => value)
      )
    def violationTarget: Optional[ViolationTarget]
    def violationTargetDescription: Optional[LengthBoundedString]
    def conflictingPriority: Optional[DnsRuleGroupPriority]
    def conflictingPolicyId: Optional[PolicyId]
    def unavailablePriorities: Optional[List[DnsRuleGroupPriority]]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getViolationTargetDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "violationTargetDescription",
        violationTargetDescription
      )
    def getConflictingPriority: ZIO[Any, AwsError, DnsRuleGroupPriority] =
      AwsError.unwrapOptionField("conflictingPriority", conflictingPriority)
    def getConflictingPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("conflictingPolicyId", conflictingPolicyId)
    def getUnavailablePriorities
        : ZIO[Any, AwsError, List[DnsRuleGroupPriority]] =
      AwsError.unwrapOptionField("unavailablePriorities", unavailablePriorities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.DnsRuleGroupPriorityConflictViolation
  ) extends zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.ReadOnly {
    override val violationTarget: Optional[ViolationTarget] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationTarget())
        .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val violationTargetDescription: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationTargetDescription())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val conflictingPriority: Optional[DnsRuleGroupPriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conflictingPriority())
        .map(value => zio.aws.fms.model.primitives.DnsRuleGroupPriority(value))
    override val conflictingPolicyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.conflictingPolicyId())
      .map(value => zio.aws.fms.model.primitives.PolicyId(value))
    override val unavailablePriorities: Optional[List[DnsRuleGroupPriority]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unavailablePriorities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.primitives.DnsRuleGroupPriority(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.DnsRuleGroupPriorityConflictViolation
  ): zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.ReadOnly =
    new Wrapper(impl)
}
