package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.LengthBoundedString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EC2AssociateRouteTableAction(
    description: Optional[LengthBoundedString] = Optional.Absent,
    routeTableId: zio.aws.fms.model.ActionTarget,
    subnetId: Optional[zio.aws.fms.model.ActionTarget] = Optional.Absent,
    gatewayId: Optional[zio.aws.fms.model.ActionTarget] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.EC2AssociateRouteTableAction = {
    import EC2AssociateRouteTableAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.EC2AssociateRouteTableAction
      .builder()
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .routeTableId(routeTableId.buildAwsValue())
      .optionallyWith(subnetId.map(value => value.buildAwsValue()))(_.subnetId)
      .optionallyWith(gatewayId.map(value => value.buildAwsValue()))(
        _.gatewayId
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.EC2AssociateRouteTableAction.ReadOnly =
    zio.aws.fms.model.EC2AssociateRouteTableAction.wrap(buildAwsValue())
}
object EC2AssociateRouteTableAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.EC2AssociateRouteTableAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.EC2AssociateRouteTableAction =
      zio.aws.fms.model.EC2AssociateRouteTableAction(
        description.map(value => value),
        routeTableId.asEditable,
        subnetId.map(value => value.asEditable),
        gatewayId.map(value => value.asEditable)
      )
    def description: Optional[LengthBoundedString]
    def routeTableId: zio.aws.fms.model.ActionTarget.ReadOnly
    def subnetId: Optional[zio.aws.fms.model.ActionTarget.ReadOnly]
    def gatewayId: Optional[zio.aws.fms.model.ActionTarget.ReadOnly]
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
    def getRouteTableId
        : ZIO[Any, Nothing, zio.aws.fms.model.ActionTarget.ReadOnly] =
      ZIO.succeed(routeTableId)
    def getSubnetId
        : ZIO[Any, AwsError, zio.aws.fms.model.ActionTarget.ReadOnly] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getGatewayId
        : ZIO[Any, AwsError, zio.aws.fms.model.ActionTarget.ReadOnly] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.EC2AssociateRouteTableAction
  ) extends zio.aws.fms.model.EC2AssociateRouteTableAction.ReadOnly {
    override val description: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val routeTableId: zio.aws.fms.model.ActionTarget.ReadOnly =
      zio.aws.fms.model.ActionTarget.wrap(impl.routeTableId())
    override val subnetId: Optional[zio.aws.fms.model.ActionTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetId())
        .map(value => zio.aws.fms.model.ActionTarget.wrap(value))
    override val gatewayId: Optional[zio.aws.fms.model.ActionTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayId())
        .map(value => zio.aws.fms.model.ActionTarget.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.EC2AssociateRouteTableAction
  ): zio.aws.fms.model.EC2AssociateRouteTableAction.ReadOnly = new Wrapper(impl)
}
