package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{ResourceId, CIDR, LengthBoundedString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EC2DeleteRouteAction(
    description: Optional[LengthBoundedString] = Optional.Absent,
    destinationCidrBlock: Optional[CIDR] = Optional.Absent,
    destinationPrefixListId: Optional[ResourceId] = Optional.Absent,
    destinationIpv6CidrBlock: Optional[CIDR] = Optional.Absent,
    routeTableId: zio.aws.fms.model.ActionTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.EC2DeleteRouteAction = {
    import EC2DeleteRouteAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.EC2DeleteRouteAction
      .builder()
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        destinationCidrBlock.map(value => CIDR.unwrap(value): java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinationPrefixListId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.destinationPrefixListId)
      .optionallyWith(
        destinationIpv6CidrBlock.map(value =>
          CIDR.unwrap(value): java.lang.String
        )
      )(_.destinationIpv6CidrBlock)
      .routeTableId(routeTableId.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.fms.model.EC2DeleteRouteAction.ReadOnly =
    zio.aws.fms.model.EC2DeleteRouteAction.wrap(buildAwsValue())
}
object EC2DeleteRouteAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.EC2DeleteRouteAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.EC2DeleteRouteAction =
      zio.aws.fms.model.EC2DeleteRouteAction(
        description.map(value => value),
        destinationCidrBlock.map(value => value),
        destinationPrefixListId.map(value => value),
        destinationIpv6CidrBlock.map(value => value),
        routeTableId.asEditable
      )
    def description: Optional[LengthBoundedString]
    def destinationCidrBlock: Optional[CIDR]
    def destinationPrefixListId: Optional[ResourceId]
    def destinationIpv6CidrBlock: Optional[CIDR]
    def routeTableId: zio.aws.fms.model.ActionTarget.ReadOnly
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
    def getDestinationCidrBlock: ZIO[Any, AwsError, CIDR] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinationPrefixListId: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("destinationPrefixListId", destinationPrefixListId)
    def getDestinationIpv6CidrBlock: ZIO[Any, AwsError, CIDR] = AwsError
      .unwrapOptionField("destinationIpv6CidrBlock", destinationIpv6CidrBlock)
    def getRouteTableId
        : ZIO[Any, Nothing, zio.aws.fms.model.ActionTarget.ReadOnly] =
      ZIO.succeed(routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.EC2DeleteRouteAction
  ) extends zio.aws.fms.model.EC2DeleteRouteAction.ReadOnly {
    override val description: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val destinationCidrBlock: Optional[CIDR] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => zio.aws.fms.model.primitives.CIDR(value))
    override val destinationPrefixListId: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPrefixListId())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val destinationIpv6CidrBlock: Optional[CIDR] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationIpv6CidrBlock())
        .map(value => zio.aws.fms.model.primitives.CIDR(value))
    override val routeTableId: zio.aws.fms.model.ActionTarget.ReadOnly =
      zio.aws.fms.model.ActionTarget.wrap(impl.routeTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.EC2DeleteRouteAction
  ): zio.aws.fms.model.EC2DeleteRouteAction.ReadOnly = new Wrapper(impl)
}
