package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceCount
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluationResult(
    complianceStatus: Optional[zio.aws.fms.model.PolicyComplianceStatusType] =
      Optional.Absent,
    violatorCount: Optional[ResourceCount] = Optional.Absent,
    evaluationLimitExceeded: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.EvaluationResult = {
    import EvaluationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.EvaluationResult
      .builder()
      .optionallyWith(complianceStatus.map(value => value.unwrap))(
        _.complianceStatus
      )
      .optionallyWith(
        violatorCount.map(value => ResourceCount.unwrap(value): java.lang.Long)
      )(_.violatorCount)
      .optionallyWith(
        evaluationLimitExceeded.map(value => value: java.lang.Boolean)
      )(_.evaluationLimitExceeded)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.EvaluationResult.ReadOnly =
    zio.aws.fms.model.EvaluationResult.wrap(buildAwsValue())
}
object EvaluationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.EvaluationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.EvaluationResult =
      zio.aws.fms.model.EvaluationResult(
        complianceStatus.map(value => value),
        violatorCount.map(value => value),
        evaluationLimitExceeded.map(value => value)
      )
    def complianceStatus: Optional[zio.aws.fms.model.PolicyComplianceStatusType]
    def violatorCount: Optional[ResourceCount]
    def evaluationLimitExceeded: Optional[Boolean]
    def getComplianceStatus
        : ZIO[Any, AwsError, zio.aws.fms.model.PolicyComplianceStatusType] =
      AwsError.unwrapOptionField("complianceStatus", complianceStatus)
    def getViolatorCount: ZIO[Any, AwsError, ResourceCount] =
      AwsError.unwrapOptionField("violatorCount", violatorCount)
    def getEvaluationLimitExceeded: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("evaluationLimitExceeded", evaluationLimitExceeded)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.EvaluationResult
  ) extends zio.aws.fms.model.EvaluationResult.ReadOnly {
    override val complianceStatus
        : Optional[zio.aws.fms.model.PolicyComplianceStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceStatus())
        .map(value => zio.aws.fms.model.PolicyComplianceStatusType.wrap(value))
    override val violatorCount: Optional[ResourceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.violatorCount())
      .map(value => zio.aws.fms.model.primitives.ResourceCount(value))
    override val evaluationLimitExceeded: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationLimitExceeded())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.EvaluationResult
  ): zio.aws.fms.model.EvaluationResult.ReadOnly = new Wrapper(impl)
}
