package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{LengthBoundedString, ResourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FirewallSubnetMissingVPCEndpointViolation(
    firewallSubnetId: Optional[ResourceId] = Optional.Absent,
    vpcId: Optional[ResourceId] = Optional.Absent,
    subnetAvailabilityZone: Optional[LengthBoundedString] = Optional.Absent,
    subnetAvailabilityZoneId: Optional[LengthBoundedString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.FirewallSubnetMissingVPCEndpointViolation = {
    import FirewallSubnetMissingVPCEndpointViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.FirewallSubnetMissingVPCEndpointViolation
      .builder()
      .optionallyWith(
        firewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallSubnetId)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetAvailabilityZone.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.subnetAvailabilityZone)
      .optionallyWith(
        subnetAvailabilityZoneId.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.subnetAvailabilityZoneId)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation.ReadOnly =
    zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation
      .wrap(buildAwsValue())
}
object FirewallSubnetMissingVPCEndpointViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.FirewallSubnetMissingVPCEndpointViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation =
      zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation(
        firewallSubnetId.map(value => value),
        vpcId.map(value => value),
        subnetAvailabilityZone.map(value => value),
        subnetAvailabilityZoneId.map(value => value)
      )
    def firewallSubnetId: Optional[ResourceId]
    def vpcId: Optional[ResourceId]
    def subnetAvailabilityZone: Optional[LengthBoundedString]
    def subnetAvailabilityZoneId: Optional[LengthBoundedString]
    def getFirewallSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallSubnetId", firewallSubnetId)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetAvailabilityZone: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZone",
        subnetAvailabilityZone
      )
    def getSubnetAvailabilityZoneId: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZoneId",
        subnetAvailabilityZoneId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.FirewallSubnetMissingVPCEndpointViolation
  ) extends zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation.ReadOnly {
    override val firewallSubnetId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallSubnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val vpcId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val subnetAvailabilityZone: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetAvailabilityZone())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val subnetAvailabilityZoneId: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetAvailabilityZoneId())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.FirewallSubnetMissingVPCEndpointViolation
  ): zio.aws.fms.model.FirewallSubnetMissingVPCEndpointViolation.ReadOnly =
    new Wrapper(impl)
}
