package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAppsListResponse(
    appsList: Optional[zio.aws.fms.model.AppsListData] = Optional.Absent,
    appsListArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetAppsListResponse = {
    import GetAppsListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetAppsListResponse
      .builder()
      .optionallyWith(appsList.map(value => value.buildAwsValue()))(_.appsList)
      .optionallyWith(
        appsListArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.appsListArn)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetAppsListResponse.ReadOnly =
    zio.aws.fms.model.GetAppsListResponse.wrap(buildAwsValue())
}
object GetAppsListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetAppsListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetAppsListResponse =
      zio.aws.fms.model.GetAppsListResponse(
        appsList.map(value => value.asEditable),
        appsListArn.map(value => value)
      )
    def appsList: Optional[zio.aws.fms.model.AppsListData.ReadOnly]
    def appsListArn: Optional[ResourceArn]
    def getAppsList
        : ZIO[Any, AwsError, zio.aws.fms.model.AppsListData.ReadOnly] =
      AwsError.unwrapOptionField("appsList", appsList)
    def getAppsListArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("appsListArn", appsListArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetAppsListResponse
  ) extends zio.aws.fms.model.GetAppsListResponse.ReadOnly {
    override val appsList: Optional[zio.aws.fms.model.AppsListData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appsList())
        .map(value => zio.aws.fms.model.AppsListData.wrap(value))
    override val appsListArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appsListArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetAppsListResponse
  ): zio.aws.fms.model.GetAppsListResponse.ReadOnly = new Wrapper(impl)
}
