package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetComplianceDetailResponse(
    policyComplianceDetail: Optional[zio.aws.fms.model.PolicyComplianceDetail] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetComplianceDetailResponse = {
    import GetComplianceDetailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetComplianceDetailResponse
      .builder()
      .optionallyWith(
        policyComplianceDetail.map(value => value.buildAwsValue())
      )(_.policyComplianceDetail)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetComplianceDetailResponse.ReadOnly =
    zio.aws.fms.model.GetComplianceDetailResponse.wrap(buildAwsValue())
}
object GetComplianceDetailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetComplianceDetailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetComplianceDetailResponse =
      zio.aws.fms.model.GetComplianceDetailResponse(
        policyComplianceDetail.map(value => value.asEditable)
      )
    def policyComplianceDetail
        : Optional[zio.aws.fms.model.PolicyComplianceDetail.ReadOnly]
    def getPolicyComplianceDetail: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.PolicyComplianceDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "policyComplianceDetail",
      policyComplianceDetail
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetComplianceDetailResponse
  ) extends zio.aws.fms.model.GetComplianceDetailResponse.ReadOnly {
    override val policyComplianceDetail
        : Optional[zio.aws.fms.model.PolicyComplianceDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyComplianceDetail())
        .map(value => zio.aws.fms.model.PolicyComplianceDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetComplianceDetailResponse
  ): zio.aws.fms.model.GetComplianceDetailResponse.ReadOnly = new Wrapper(impl)
}
