package zio.aws.fms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.{
  PaginationMaxResults,
  AWSAccountId,
  PaginationToken,
  TimeStamp,
  PolicyId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetProtectionStatusRequest(
    policyId: PolicyId,
    memberAccountId: Optional[AWSAccountId] = Optional.Absent,
    startTime: Optional[TimeStamp] = Optional.Absent,
    endTime: Optional[TimeStamp] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PaginationMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest = {
    import GetProtectionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .optionallyWith(
        memberAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.memberAccountId)
      .optionallyWith(startTime.map(value => TimeStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TimeStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetProtectionStatusRequest.ReadOnly =
    zio.aws.fms.model.GetProtectionStatusRequest.wrap(buildAwsValue())
}
object GetProtectionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetProtectionStatusRequest =
      zio.aws.fms.model.GetProtectionStatusRequest(
        policyId,
        memberAccountId.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def policyId: PolicyId
    def memberAccountId: Optional[AWSAccountId]
    def startTime: Optional[TimeStamp]
    def endTime: Optional[TimeStamp]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PaginationMaxResults]
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
    def getMemberAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("memberAccountId", memberAccountId)
    def getStartTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest
  ) extends zio.aws.fms.model.GetProtectionStatusRequest.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.fms.model.primitives.PolicyId(impl.policyId())
    override val memberAccountId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.memberAccountId())
      .map(value => zio.aws.fms.model.primitives.AWSAccountId(value))
    override val startTime: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val endTime: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
    override val maxResults: Optional[PaginationMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.fms.model.primitives.PaginationMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest
  ): zio.aws.fms.model.GetProtectionStatusRequest.ReadOnly = new Wrapper(impl)
}
