package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  PaginationToken,
  ProtectionData,
  AWSAccountId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetProtectionStatusResponse(
    adminAccountId: Optional[AWSAccountId] = Optional.Absent,
    serviceType: Optional[zio.aws.fms.model.SecurityServiceType] =
      Optional.Absent,
    data: Optional[ProtectionData] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse = {
    import GetProtectionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse
      .builder()
      .optionallyWith(
        adminAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.adminAccountId)
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .optionallyWith(
        data.map(value => ProtectionData.unwrap(value): java.lang.String)
      )(_.data)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly =
    zio.aws.fms.model.GetProtectionStatusResponse.wrap(buildAwsValue())
}
object GetProtectionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetProtectionStatusResponse =
      zio.aws.fms.model.GetProtectionStatusResponse(
        adminAccountId.map(value => value),
        serviceType.map(value => value),
        data.map(value => value),
        nextToken.map(value => value)
      )
    def adminAccountId: Optional[AWSAccountId]
    def serviceType: Optional[zio.aws.fms.model.SecurityServiceType]
    def data: Optional[ProtectionData]
    def nextToken: Optional[PaginationToken]
    def getAdminAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("adminAccountId", adminAccountId)
    def getServiceType
        : ZIO[Any, AwsError, zio.aws.fms.model.SecurityServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
    def getData: ZIO[Any, AwsError, ProtectionData] =
      AwsError.unwrapOptionField("data", data)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse
  ) extends zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly {
    override val adminAccountId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.adminAccountId())
      .map(value => zio.aws.fms.model.primitives.AWSAccountId(value))
    override val serviceType: Optional[zio.aws.fms.model.SecurityServiceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceType())
        .map(value => zio.aws.fms.model.SecurityServiceType.wrap(value))
    override val data: Optional[ProtectionData] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => zio.aws.fms.model.primitives.ProtectionData(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse
  ): zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly = new Wrapper(impl)
}
