package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetThirdPartyFirewallAssociationStatusResponse(
    thirdPartyFirewallStatus: Optional[
      zio.aws.fms.model.ThirdPartyFirewallAssociationStatus
    ] = Optional.Absent,
    marketplaceOnboardingStatus: Optional[
      zio.aws.fms.model.MarketplaceSubscriptionOnboardingStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetThirdPartyFirewallAssociationStatusResponse = {
    import GetThirdPartyFirewallAssociationStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetThirdPartyFirewallAssociationStatusResponse
      .builder()
      .optionallyWith(thirdPartyFirewallStatus.map(value => value.unwrap))(
        _.thirdPartyFirewallStatus
      )
      .optionallyWith(marketplaceOnboardingStatus.map(value => value.unwrap))(
        _.marketplaceOnboardingStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.GetThirdPartyFirewallAssociationStatusResponse.ReadOnly =
    zio.aws.fms.model.GetThirdPartyFirewallAssociationStatusResponse
      .wrap(buildAwsValue())
}
object GetThirdPartyFirewallAssociationStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetThirdPartyFirewallAssociationStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.GetThirdPartyFirewallAssociationStatusResponse =
      zio.aws.fms.model.GetThirdPartyFirewallAssociationStatusResponse(
        thirdPartyFirewallStatus.map(value => value),
        marketplaceOnboardingStatus.map(value => value)
      )
    def thirdPartyFirewallStatus
        : Optional[zio.aws.fms.model.ThirdPartyFirewallAssociationStatus]
    def marketplaceOnboardingStatus
        : Optional[zio.aws.fms.model.MarketplaceSubscriptionOnboardingStatus]
    def getThirdPartyFirewallStatus: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.ThirdPartyFirewallAssociationStatus
    ] = AwsError.unwrapOptionField(
      "thirdPartyFirewallStatus",
      thirdPartyFirewallStatus
    )
    def getMarketplaceOnboardingStatus: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.MarketplaceSubscriptionOnboardingStatus
    ] = AwsError.unwrapOptionField(
      "marketplaceOnboardingStatus",
      marketplaceOnboardingStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetThirdPartyFirewallAssociationStatusResponse
  ) extends zio.aws.fms.model.GetThirdPartyFirewallAssociationStatusResponse.ReadOnly {
    override val thirdPartyFirewallStatus
        : Optional[zio.aws.fms.model.ThirdPartyFirewallAssociationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thirdPartyFirewallStatus())
        .map(value =>
          zio.aws.fms.model.ThirdPartyFirewallAssociationStatus.wrap(value)
        )
    override val marketplaceOnboardingStatus
        : Optional[zio.aws.fms.model.MarketplaceSubscriptionOnboardingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.marketplaceOnboardingStatus())
        .map(value =>
          zio.aws.fms.model.MarketplaceSubscriptionOnboardingStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetThirdPartyFirewallAssociationStatusResponse
  ): zio.aws.fms.model.GetThirdPartyFirewallAssociationStatusResponse.ReadOnly =
    new Wrapper(impl)
}
