package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetViolationDetailsResponse(
    violationDetail: Optional[zio.aws.fms.model.ViolationDetail] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetViolationDetailsResponse = {
    import GetViolationDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetViolationDetailsResponse
      .builder()
      .optionallyWith(violationDetail.map(value => value.buildAwsValue()))(
        _.violationDetail
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetViolationDetailsResponse.ReadOnly =
    zio.aws.fms.model.GetViolationDetailsResponse.wrap(buildAwsValue())
}
object GetViolationDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetViolationDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetViolationDetailsResponse =
      zio.aws.fms.model.GetViolationDetailsResponse(
        violationDetail.map(value => value.asEditable)
      )
    def violationDetail: Optional[zio.aws.fms.model.ViolationDetail.ReadOnly]
    def getViolationDetail
        : ZIO[Any, AwsError, zio.aws.fms.model.ViolationDetail.ReadOnly] =
      AwsError.unwrapOptionField("violationDetail", violationDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetViolationDetailsResponse
  ) extends zio.aws.fms.model.GetViolationDetailsResponse.ReadOnly {
    override val violationDetail
        : Optional[zio.aws.fms.model.ViolationDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationDetail())
        .map(value => zio.aws.fms.model.ViolationDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetViolationDetailsResponse
  ): zio.aws.fms.model.GetViolationDetailsResponse.ReadOnly = new Wrapper(impl)
}
