package zio.aws.fms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.{
  PaginationMaxResults,
  PaginationToken,
  PolicyId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListComplianceStatusRequest(
    policyId: PolicyId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PaginationMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest = {
    import ListComplianceStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListComplianceStatusRequest.ReadOnly =
    zio.aws.fms.model.ListComplianceStatusRequest.wrap(buildAwsValue())
}
object ListComplianceStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListComplianceStatusRequest =
      zio.aws.fms.model.ListComplianceStatusRequest(
        policyId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def policyId: PolicyId
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PaginationMaxResults]
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest
  ) extends zio.aws.fms.model.ListComplianceStatusRequest.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.fms.model.primitives.PolicyId(impl.policyId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
    override val maxResults: Optional[PaginationMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.fms.model.primitives.PaginationMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest
  ): zio.aws.fms.model.ListComplianceStatusRequest.ReadOnly = new Wrapper(impl)
}
