package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPoliciesResponse(
    policyList: Optional[Iterable[zio.aws.fms.model.PolicySummary]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListPoliciesResponse = {
    import ListPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListPoliciesResponse
      .builder()
      .optionallyWith(
        policyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListPoliciesResponse.ReadOnly =
    zio.aws.fms.model.ListPoliciesResponse.wrap(buildAwsValue())
}
object ListPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListPoliciesResponse =
      zio.aws.fms.model.ListPoliciesResponse(
        policyList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def policyList: Optional[List[zio.aws.fms.model.PolicySummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getPolicyList
        : ZIO[Any, AwsError, List[zio.aws.fms.model.PolicySummary.ReadOnly]] =
      AwsError.unwrapOptionField("policyList", policyList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListPoliciesResponse
  ) extends zio.aws.fms.model.ListPoliciesResponse.ReadOnly {
    override val policyList
        : Optional[List[zio.aws.fms.model.PolicySummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.PolicySummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListPoliciesResponse
  ): zio.aws.fms.model.ListPoliciesResponse.ReadOnly = new Wrapper(impl)
}
