package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListProtocolsListsResponse(
    protocolsLists: Optional[
      Iterable[zio.aws.fms.model.ProtocolsListDataSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse = {
    import ListProtocolsListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse
      .builder()
      .optionallyWith(
        protocolsLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.protocolsLists)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly =
    zio.aws.fms.model.ListProtocolsListsResponse.wrap(buildAwsValue())
}
object ListProtocolsListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListProtocolsListsResponse =
      zio.aws.fms.model.ListProtocolsListsResponse(
        protocolsLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def protocolsLists
        : Optional[List[zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getProtocolsLists: ZIO[Any, AwsError, List[
      zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("protocolsLists", protocolsLists)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse
  ) extends zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly {
    override val protocolsLists
        : Optional[List[zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocolsLists())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.ProtocolsListDataSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse
  ): zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly = new Wrapper(impl)
}
