package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListThirdPartyFirewallFirewallPoliciesResponse(
    thirdPartyFirewallFirewallPolicies: Optional[
      Iterable[zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse = {
    import ListThirdPartyFirewallFirewallPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse
      .builder()
      .optionallyWith(
        thirdPartyFirewallFirewallPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.thirdPartyFirewallFirewallPolicies)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse.ReadOnly =
    zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse
      .wrap(buildAwsValue())
}
object ListThirdPartyFirewallFirewallPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse =
      zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse(
        thirdPartyFirewallFirewallPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def thirdPartyFirewallFirewallPolicies: Optional[
      List[zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getThirdPartyFirewallFirewallPolicies: ZIO[Any, AwsError, List[
      zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "thirdPartyFirewallFirewallPolicies",
      thirdPartyFirewallFirewallPolicies
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse
  ) extends zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse.ReadOnly {
    override val thirdPartyFirewallFirewallPolicies: Optional[
      List[zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.thirdPartyFirewallFirewallPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse
  ): zio.aws.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
