package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{ResourceId, ViolationTarget}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallBlackHoleRouteDetectedViolation(
    violationTarget: Optional[ViolationTarget] = Optional.Absent,
    routeTableId: Optional[ResourceId] = Optional.Absent,
    vpcId: Optional[ResourceId] = Optional.Absent,
    violatingRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation = {
    import NetworkFirewallBlackHoleRouteDetectedViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        violatingRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violatingRoutes)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallBlackHoleRouteDetectedViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation =
      zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation(
        violationTarget.map(value => value),
        routeTableId.map(value => value),
        vpcId.map(value => value),
        violatingRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def violationTarget: Optional[ViolationTarget]
    def routeTableId: Optional[ResourceId]
    def vpcId: Optional[ResourceId]
    def violatingRoutes: Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getViolatingRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("violatingRoutes", violatingRoutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation
  ) extends zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation.ReadOnly {
    override val violationTarget: Optional[ViolationTarget] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationTarget())
        .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val routeTableId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val vpcId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val violatingRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violatingRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation
  ): zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation.ReadOnly =
    new Wrapper(impl)
}
