package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{LengthBoundedString, ResourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallInternetTrafficNotInspectedViolation(
    subnetId: Optional[ResourceId] = Optional.Absent,
    subnetAvailabilityZone: Optional[LengthBoundedString] = Optional.Absent,
    routeTableId: Optional[ResourceId] = Optional.Absent,
    violatingRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent,
    isRouteTableUsedInDifferentAZ: Optional[Boolean] = Optional.Absent,
    currentFirewallSubnetRouteTable: Optional[ResourceId] = Optional.Absent,
    expectedFirewallEndpoint: Optional[ResourceId] = Optional.Absent,
    firewallSubnetId: Optional[ResourceId] = Optional.Absent,
    expectedFirewallSubnetRoutes: Optional[
      Iterable[zio.aws.fms.model.ExpectedRoute]
    ] = Optional.Absent,
    actualFirewallSubnetRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent,
    internetGatewayId: Optional[ResourceId] = Optional.Absent,
    currentInternetGatewayRouteTable: Optional[ResourceId] = Optional.Absent,
    expectedInternetGatewayRoutes: Optional[
      Iterable[zio.aws.fms.model.ExpectedRoute]
    ] = Optional.Absent,
    actualInternetGatewayRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent,
    vpcId: Optional[ResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation = {
    import NetworkFirewallInternetTrafficNotInspectedViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
      .builder()
      .optionallyWith(
        subnetId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        subnetAvailabilityZone.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.subnetAvailabilityZone)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .optionallyWith(
        violatingRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violatingRoutes)
      .optionallyWith(
        isRouteTableUsedInDifferentAZ.map(value => value: java.lang.Boolean)
      )(_.isRouteTableUsedInDifferentAZ)
      .optionallyWith(
        currentFirewallSubnetRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentFirewallSubnetRouteTable)
      .optionallyWith(
        expectedFirewallEndpoint.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.expectedFirewallEndpoint)
      .optionallyWith(
        firewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallSubnetId)
      .optionallyWith(
        expectedFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expectedFirewallSubnetRoutes)
      .optionallyWith(
        actualFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actualFirewallSubnetRoutes)
      .optionallyWith(
        internetGatewayId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.internetGatewayId)
      .optionallyWith(
        currentInternetGatewayRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentInternetGatewayRouteTable)
      .optionallyWith(
        expectedInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expectedInternetGatewayRoutes)
      .optionallyWith(
        actualInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actualInternetGatewayRoutes)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallInternetTrafficNotInspectedViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation =
      zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation(
        subnetId.map(value => value),
        subnetAvailabilityZone.map(value => value),
        routeTableId.map(value => value),
        violatingRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isRouteTableUsedInDifferentAZ.map(value => value),
        currentFirewallSubnetRouteTable.map(value => value),
        expectedFirewallEndpoint.map(value => value),
        firewallSubnetId.map(value => value),
        expectedFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actualFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        internetGatewayId.map(value => value),
        currentInternetGatewayRouteTable.map(value => value),
        expectedInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actualInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def subnetId: Optional[ResourceId]
    def subnetAvailabilityZone: Optional[LengthBoundedString]
    def routeTableId: Optional[ResourceId]
    def violatingRoutes: Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def isRouteTableUsedInDifferentAZ: Optional[Boolean]
    def currentFirewallSubnetRouteTable: Optional[ResourceId]
    def expectedFirewallEndpoint: Optional[ResourceId]
    def firewallSubnetId: Optional[ResourceId]
    def expectedFirewallSubnetRoutes
        : Optional[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]]
    def actualFirewallSubnetRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def internetGatewayId: Optional[ResourceId]
    def currentInternetGatewayRouteTable: Optional[ResourceId]
    def expectedInternetGatewayRoutes
        : Optional[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]]
    def actualInternetGatewayRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def vpcId: Optional[ResourceId]
    def getSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getSubnetAvailabilityZone: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZone",
        subnetAvailabilityZone
      )
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getViolatingRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("violatingRoutes", violatingRoutes)
    def getIsRouteTableUsedInDifferentAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "isRouteTableUsedInDifferentAZ",
        isRouteTableUsedInDifferentAZ
      )
    def getCurrentFirewallSubnetRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentFirewallSubnetRouteTable",
        currentFirewallSubnetRouteTable
      )
    def getExpectedFirewallEndpoint: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("expectedFirewallEndpoint", expectedFirewallEndpoint)
    def getFirewallSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallSubnetId", firewallSubnetId)
    def getExpectedFirewallSubnetRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      AwsError.unwrapOptionField(
        "expectedFirewallSubnetRoutes",
        expectedFirewallSubnetRoutes
      )
    def getActualFirewallSubnetRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField(
        "actualFirewallSubnetRoutes",
        actualFirewallSubnetRoutes
      )
    def getInternetGatewayId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("internetGatewayId", internetGatewayId)
    def getCurrentInternetGatewayRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentInternetGatewayRouteTable",
        currentInternetGatewayRouteTable
      )
    def getExpectedInternetGatewayRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      AwsError.unwrapOptionField(
        "expectedInternetGatewayRoutes",
        expectedInternetGatewayRoutes
      )
    def getActualInternetGatewayRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField(
        "actualInternetGatewayRoutes",
        actualInternetGatewayRoutes
      )
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
  ) extends zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly {
    override val subnetId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val subnetAvailabilityZone: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetAvailabilityZone())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val routeTableId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val violatingRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violatingRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
    override val isRouteTableUsedInDifferentAZ: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isRouteTableUsedInDifferentAZ())
        .map(value => value: Boolean)
    override val currentFirewallSubnetRouteTable: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentFirewallSubnetRouteTable())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedFirewallEndpoint: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedFirewallEndpoint())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val firewallSubnetId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallSubnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedFirewallSubnetRoutes
        : Optional[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedFirewallSubnetRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.ExpectedRoute.wrap(item)
          }.toList
        )
    override val actualFirewallSubnetRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualFirewallSubnetRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
    override val internetGatewayId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.internetGatewayId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val currentInternetGatewayRouteTable: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentInternetGatewayRouteTable())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedInternetGatewayRoutes
        : Optional[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedInternetGatewayRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.ExpectedRoute.wrap(item)
          }.toList
        )
    override val actualInternetGatewayRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualInternetGatewayRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
    override val vpcId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
  ): zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly =
    new Wrapper(impl)
}
