package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ViolationTarget
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallPolicyModifiedViolation(
    violationTarget: Optional[ViolationTarget] = Optional.Absent,
    currentPolicyDescription: Optional[
      zio.aws.fms.model.NetworkFirewallPolicyDescription
    ] = Optional.Absent,
    expectedPolicyDescription: Optional[
      zio.aws.fms.model.NetworkFirewallPolicyDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation = {
    import NetworkFirewallPolicyModifiedViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        currentPolicyDescription.map(value => value.buildAwsValue())
      )(_.currentPolicyDescription)
      .optionallyWith(
        expectedPolicyDescription.map(value => value.buildAwsValue())
      )(_.expectedPolicyDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallPolicyModifiedViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation =
      zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation(
        violationTarget.map(value => value),
        currentPolicyDescription.map(value => value.asEditable),
        expectedPolicyDescription.map(value => value.asEditable)
      )
    def violationTarget: Optional[ViolationTarget]
    def currentPolicyDescription
        : Optional[zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly]
    def expectedPolicyDescription
        : Optional[zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getCurrentPolicyDescription: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "currentPolicyDescription",
      currentPolicyDescription
    )
    def getExpectedPolicyDescription: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "expectedPolicyDescription",
      expectedPolicyDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation
  ) extends zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly {
    override val violationTarget: Optional[ViolationTarget] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationTarget())
        .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val currentPolicyDescription: Optional[
      zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.currentPolicyDescription())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallPolicyDescription.wrap(value)
      )
    override val expectedPolicyDescription: Optional[
      zio.aws.fms.model.NetworkFirewallPolicyDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.expectedPolicyDescription())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallPolicyDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation
  ): zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly =
    new Wrapper(impl)
}
