package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  ResourceType,
  PolicyUpdateToken,
  CustomerPolicyScopeId,
  PolicyId,
  ResourceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Policy(
    policyId: Optional[PolicyId] = Optional.Absent,
    policyName: ResourceName,
    policyUpdateToken: Optional[PolicyUpdateToken] = Optional.Absent,
    securityServicePolicyData: zio.aws.fms.model.SecurityServicePolicyData,
    resourceType: ResourceType,
    resourceTypeList: Optional[Iterable[ResourceType]] = Optional.Absent,
    resourceTags: Optional[Iterable[zio.aws.fms.model.ResourceTag]] =
      Optional.Absent,
    excludeResourceTags: Boolean,
    remediationEnabled: Boolean,
    deleteUnusedFMManagedResources: Optional[Boolean] = Optional.Absent,
    includeMap: Optional[
      Map[zio.aws.fms.model.CustomerPolicyScopeIdType, Iterable[
        CustomerPolicyScopeId
      ]]
    ] = Optional.Absent,
    excludeMap: Optional[
      Map[zio.aws.fms.model.CustomerPolicyScopeIdType, Iterable[
        CustomerPolicyScopeId
      ]]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.fms.model.Policy = {
    import Policy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.Policy
      .builder()
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .policyName(ResourceName.unwrap(policyName): java.lang.String)
      .optionallyWith(
        policyUpdateToken.map(value =>
          PolicyUpdateToken.unwrap(value): java.lang.String
        )
      )(_.policyUpdateToken)
      .securityServicePolicyData(securityServicePolicyData.buildAwsValue())
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .optionallyWith(
        resourceTypeList.map(value =>
          value.map { item =>
            ResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypeList)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .excludeResourceTags(excludeResourceTags: java.lang.Boolean)
      .remediationEnabled(remediationEnabled: java.lang.Boolean)
      .optionallyWith(
        deleteUnusedFMManagedResources.map(value => value: java.lang.Boolean)
      )(_.deleteUnusedFMManagedResources)
      .optionallyWith(
        includeMap.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                CustomerPolicyScopeId.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.includeMapWithStrings)
      .optionallyWith(
        excludeMap.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                CustomerPolicyScopeId.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.excludeMapWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.Policy.ReadOnly =
    zio.aws.fms.model.Policy.wrap(buildAwsValue())
}
object Policy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.Policy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.Policy = zio.aws.fms.model.Policy(
      policyId.map(value => value),
      policyName,
      policyUpdateToken.map(value => value),
      securityServicePolicyData.asEditable,
      resourceType,
      resourceTypeList.map(value => value),
      resourceTags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      excludeResourceTags,
      remediationEnabled,
      deleteUnusedFMManagedResources.map(value => value),
      includeMap.map(value => value),
      excludeMap.map(value => value)
    )
    def policyId: Optional[PolicyId]
    def policyName: ResourceName
    def policyUpdateToken: Optional[PolicyUpdateToken]
    def securityServicePolicyData
        : zio.aws.fms.model.SecurityServicePolicyData.ReadOnly
    def resourceType: ResourceType
    def resourceTypeList: Optional[List[ResourceType]]
    def resourceTags: Optional[List[zio.aws.fms.model.ResourceTag.ReadOnly]]
    def excludeResourceTags: Boolean
    def remediationEnabled: Boolean
    def deleteUnusedFMManagedResources: Optional[Boolean]
    def includeMap
        : Optional[Map[zio.aws.fms.model.CustomerPolicyScopeIdType, List[
          CustomerPolicyScopeId
        ]]]
    def excludeMap
        : Optional[Map[zio.aws.fms.model.CustomerPolicyScopeIdType, List[
          CustomerPolicyScopeId
        ]]]
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getPolicyName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(policyName)
    def getPolicyUpdateToken: ZIO[Any, AwsError, PolicyUpdateToken] =
      AwsError.unwrapOptionField("policyUpdateToken", policyUpdateToken)
    def getSecurityServicePolicyData: ZIO[
      Any,
      Nothing,
      zio.aws.fms.model.SecurityServicePolicyData.ReadOnly
    ] = ZIO.succeed(securityServicePolicyData)
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
    def getResourceTypeList: ZIO[Any, AwsError, List[ResourceType]] =
      AwsError.unwrapOptionField("resourceTypeList", resourceTypeList)
    def getResourceTags
        : ZIO[Any, AwsError, List[zio.aws.fms.model.ResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getExcludeResourceTags: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(excludeResourceTags)
    def getRemediationEnabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(remediationEnabled)
    def getDeleteUnusedFMManagedResources: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "deleteUnusedFMManagedResources",
        deleteUnusedFMManagedResources
      )
    def getIncludeMap: ZIO[Any, AwsError, Map[
      zio.aws.fms.model.CustomerPolicyScopeIdType,
      List[CustomerPolicyScopeId]
    ]] = AwsError.unwrapOptionField("includeMap", includeMap)
    def getExcludeMap: ZIO[Any, AwsError, Map[
      zio.aws.fms.model.CustomerPolicyScopeIdType,
      List[CustomerPolicyScopeId]
    ]] = AwsError.unwrapOptionField("excludeMap", excludeMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.Policy
  ) extends zio.aws.fms.model.Policy.ReadOnly {
    override val policyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.fms.model.primitives.PolicyId(value))
    override val policyName: ResourceName =
      zio.aws.fms.model.primitives.ResourceName(impl.policyName())
    override val policyUpdateToken: Optional[PolicyUpdateToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyUpdateToken())
        .map(value => zio.aws.fms.model.primitives.PolicyUpdateToken(value))
    override val securityServicePolicyData
        : zio.aws.fms.model.SecurityServicePolicyData.ReadOnly =
      zio.aws.fms.model.SecurityServicePolicyData
        .wrap(impl.securityServicePolicyData())
    override val resourceType: ResourceType =
      zio.aws.fms.model.primitives.ResourceType(impl.resourceType())
    override val resourceTypeList: Optional[List[ResourceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypeList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.primitives.ResourceType(item)
          }.toList
        )
    override val resourceTags
        : Optional[List[zio.aws.fms.model.ResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.ResourceTag.wrap(item)
          }.toList
        )
    override val excludeResourceTags: Boolean =
      impl.excludeResourceTags(): Boolean
    override val remediationEnabled: Boolean =
      impl.remediationEnabled(): Boolean
    override val deleteUnusedFMManagedResources: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteUnusedFMManagedResources())
        .map(value => value: Boolean)
    override val includeMap
        : Optional[Map[zio.aws.fms.model.CustomerPolicyScopeIdType, List[
          CustomerPolicyScopeId
        ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.includeMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.fms.model.CustomerPolicyScopeIdType
              .wrap(key) -> value.asScala.map { item =>
              zio.aws.fms.model.primitives.CustomerPolicyScopeId(item)
            }.toList
          })
          .toMap
      )
    override val excludeMap
        : Optional[Map[zio.aws.fms.model.CustomerPolicyScopeIdType, List[
          CustomerPolicyScopeId
        ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.excludeMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.fms.model.CustomerPolicyScopeIdType
              .wrap(key) -> value.asScala.map { item =>
              zio.aws.fms.model.primitives.CustomerPolicyScopeId(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.Policy
  ): zio.aws.fms.model.Policy.ReadOnly = new Wrapper(impl)
}
