package zio.aws.fms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.{
  DetailedInfo,
  TimeStamp,
  PolicyId,
  AWSAccountId
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class PolicyComplianceDetail(
    policyOwner: Optional[AWSAccountId] = Optional.Absent,
    policyId: Optional[PolicyId] = Optional.Absent,
    memberAccount: Optional[AWSAccountId] = Optional.Absent,
    violators: Optional[Iterable[zio.aws.fms.model.ComplianceViolator]] =
      Optional.Absent,
    evaluationLimitExceeded: Optional[Boolean] = Optional.Absent,
    expiredAt: Optional[TimeStamp] = Optional.Absent,
    issueInfoMap: Optional[
      Map[zio.aws.fms.model.DependentServiceName, DetailedInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PolicyComplianceDetail = {
    import PolicyComplianceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PolicyComplianceDetail
      .builder()
      .optionallyWith(
        policyOwner.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.policyOwner)
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        memberAccount.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.memberAccount)
      .optionallyWith(
        violators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violators)
      .optionallyWith(
        evaluationLimitExceeded.map(value => value: java.lang.Boolean)
      )(_.evaluationLimitExceeded)
      .optionallyWith(expiredAt.map(value => TimeStamp.unwrap(value): Instant))(
        _.expiredAt
      )
      .optionallyWith(
        issueInfoMap.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (DetailedInfo
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.issueInfoMapWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PolicyComplianceDetail.ReadOnly =
    zio.aws.fms.model.PolicyComplianceDetail.wrap(buildAwsValue())
}
object PolicyComplianceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.PolicyComplianceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PolicyComplianceDetail =
      zio.aws.fms.model.PolicyComplianceDetail(
        policyOwner.map(value => value),
        policyId.map(value => value),
        memberAccount.map(value => value),
        violators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        evaluationLimitExceeded.map(value => value),
        expiredAt.map(value => value),
        issueInfoMap.map(value => value)
      )
    def policyOwner: Optional[AWSAccountId]
    def policyId: Optional[PolicyId]
    def memberAccount: Optional[AWSAccountId]
    def violators: Optional[List[zio.aws.fms.model.ComplianceViolator.ReadOnly]]
    def evaluationLimitExceeded: Optional[Boolean]
    def expiredAt: Optional[TimeStamp]
    def issueInfoMap
        : Optional[Map[zio.aws.fms.model.DependentServiceName, DetailedInfo]]
    def getPolicyOwner: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("policyOwner", policyOwner)
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getMemberAccount: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("memberAccount", memberAccount)
    def getViolators: ZIO[Any, AwsError, List[
      zio.aws.fms.model.ComplianceViolator.ReadOnly
    ]] = AwsError.unwrapOptionField("violators", violators)
    def getEvaluationLimitExceeded: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("evaluationLimitExceeded", evaluationLimitExceeded)
    def getExpiredAt: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("expiredAt", expiredAt)
    def getIssueInfoMap: ZIO[Any, AwsError, Map[
      zio.aws.fms.model.DependentServiceName,
      DetailedInfo
    ]] = AwsError.unwrapOptionField("issueInfoMap", issueInfoMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PolicyComplianceDetail
  ) extends zio.aws.fms.model.PolicyComplianceDetail.ReadOnly {
    override val policyOwner: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyOwner())
      .map(value => zio.aws.fms.model.primitives.AWSAccountId(value))
    override val policyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.fms.model.primitives.PolicyId(value))
    override val memberAccount: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.memberAccount())
      .map(value => zio.aws.fms.model.primitives.AWSAccountId(value))
    override val violators
        : Optional[List[zio.aws.fms.model.ComplianceViolator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.ComplianceViolator.wrap(item)
          }.toList
        )
    override val evaluationLimitExceeded: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationLimitExceeded())
        .map(value => value: Boolean)
    override val expiredAt: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiredAt())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val issueInfoMap
        : Optional[Map[zio.aws.fms.model.DependentServiceName, DetailedInfo]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.issueInfoMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.fms.model.DependentServiceName
                .wrap(key) -> zio.aws.fms.model.primitives.DetailedInfo(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PolicyComplianceDetail
  ): zio.aws.fms.model.PolicyComplianceDetail.ReadOnly = new Wrapper(impl)
}
