package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  ResourceType,
  ResourceName,
  PolicyId,
  ResourceArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PolicySummary(
    policyArn: Optional[ResourceArn] = Optional.Absent,
    policyId: Optional[PolicyId] = Optional.Absent,
    policyName: Optional[ResourceName] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    securityServiceType: Optional[zio.aws.fms.model.SecurityServiceType] =
      Optional.Absent,
    remediationEnabled: Optional[Boolean] = Optional.Absent,
    deleteUnusedFMManagedResources: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PolicySummary = {
    import PolicySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PolicySummary
      .builder()
      .optionallyWith(
        policyArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        policyName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(securityServiceType.map(value => value.unwrap))(
        _.securityServiceType
      )
      .optionallyWith(
        remediationEnabled.map(value => value: java.lang.Boolean)
      )(_.remediationEnabled)
      .optionallyWith(
        deleteUnusedFMManagedResources.map(value => value: java.lang.Boolean)
      )(_.deleteUnusedFMManagedResources)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PolicySummary.ReadOnly =
    zio.aws.fms.model.PolicySummary.wrap(buildAwsValue())
}
object PolicySummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.PolicySummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PolicySummary =
      zio.aws.fms.model.PolicySummary(
        policyArn.map(value => value),
        policyId.map(value => value),
        policyName.map(value => value),
        resourceType.map(value => value),
        securityServiceType.map(value => value),
        remediationEnabled.map(value => value),
        deleteUnusedFMManagedResources.map(value => value)
      )
    def policyArn: Optional[ResourceArn]
    def policyId: Optional[PolicyId]
    def policyName: Optional[ResourceName]
    def resourceType: Optional[ResourceType]
    def securityServiceType: Optional[zio.aws.fms.model.SecurityServiceType]
    def remediationEnabled: Optional[Boolean]
    def deleteUnusedFMManagedResources: Optional[Boolean]
    def getPolicyArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getPolicyName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSecurityServiceType
        : ZIO[Any, AwsError, zio.aws.fms.model.SecurityServiceType] =
      AwsError.unwrapOptionField("securityServiceType", securityServiceType)
    def getRemediationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remediationEnabled", remediationEnabled)
    def getDeleteUnusedFMManagedResources: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "deleteUnusedFMManagedResources",
        deleteUnusedFMManagedResources
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PolicySummary
  ) extends zio.aws.fms.model.PolicySummary.ReadOnly {
    override val policyArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.policyArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
    override val policyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.fms.model.primitives.PolicyId(value))
    override val policyName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.fms.model.primitives.ResourceName(value))
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.fms.model.primitives.ResourceType(value))
    override val securityServiceType
        : Optional[zio.aws.fms.model.SecurityServiceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityServiceType())
        .map(value => zio.aws.fms.model.SecurityServiceType.wrap(value))
    override val remediationEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.remediationEnabled())
      .map(value => value: Boolean)
    override val deleteUnusedFMManagedResources: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteUnusedFMManagedResources())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PolicySummary
  ): zio.aws.fms.model.PolicySummary.ReadOnly = new Wrapper(impl)
}
