package zio.aws.fms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.BasicInteger
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RemediationActionWithOrder(
    remediationAction: Optional[zio.aws.fms.model.RemediationAction] =
      Optional.Absent,
    order: Optional[BasicInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.RemediationActionWithOrder = {
    import RemediationActionWithOrder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.RemediationActionWithOrder
      .builder()
      .optionallyWith(remediationAction.map(value => value.buildAwsValue()))(
        _.remediationAction
      )
      .optionallyWith(order.map(value => BasicInteger.unwrap(value): Integer))(
        _.order
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.RemediationActionWithOrder.ReadOnly =
    zio.aws.fms.model.RemediationActionWithOrder.wrap(buildAwsValue())
}
object RemediationActionWithOrder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.RemediationActionWithOrder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.RemediationActionWithOrder =
      zio.aws.fms.model.RemediationActionWithOrder(
        remediationAction.map(value => value.asEditable),
        order.map(value => value)
      )
    def remediationAction
        : Optional[zio.aws.fms.model.RemediationAction.ReadOnly]
    def order: Optional[BasicInteger]
    def getRemediationAction
        : ZIO[Any, AwsError, zio.aws.fms.model.RemediationAction.ReadOnly] =
      AwsError.unwrapOptionField("remediationAction", remediationAction)
    def getOrder: ZIO[Any, AwsError, BasicInteger] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.RemediationActionWithOrder
  ) extends zio.aws.fms.model.RemediationActionWithOrder.ReadOnly {
    override val remediationAction
        : Optional[zio.aws.fms.model.RemediationAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remediationAction())
        .map(value => zio.aws.fms.model.RemediationAction.wrap(value))
    override val order: Optional[BasicInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.order())
      .map(value => zio.aws.fms.model.primitives.BasicInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.RemediationActionWithOrder
  ): zio.aws.fms.model.RemediationActionWithOrder.ReadOnly = new Wrapper(impl)
}
