package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{LengthBoundedString, ResourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RouteHasOutOfScopeEndpointViolation(
    subnetId: Optional[ResourceId] = Optional.Absent,
    vpcId: Optional[ResourceId] = Optional.Absent,
    routeTableId: Optional[ResourceId] = Optional.Absent,
    violatingRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent,
    subnetAvailabilityZone: Optional[LengthBoundedString] = Optional.Absent,
    subnetAvailabilityZoneId: Optional[LengthBoundedString] = Optional.Absent,
    currentFirewallSubnetRouteTable: Optional[ResourceId] = Optional.Absent,
    firewallSubnetId: Optional[ResourceId] = Optional.Absent,
    firewallSubnetRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent,
    internetGatewayId: Optional[ResourceId] = Optional.Absent,
    currentInternetGatewayRouteTable: Optional[ResourceId] = Optional.Absent,
    internetGatewayRoutes: Optional[Iterable[zio.aws.fms.model.Route]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation = {
    import RouteHasOutOfScopeEndpointViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation
      .builder()
      .optionallyWith(
        subnetId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .optionallyWith(
        violatingRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violatingRoutes)
      .optionallyWith(
        subnetAvailabilityZone.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.subnetAvailabilityZone)
      .optionallyWith(
        subnetAvailabilityZoneId.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.subnetAvailabilityZoneId)
      .optionallyWith(
        currentFirewallSubnetRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentFirewallSubnetRouteTable)
      .optionallyWith(
        firewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallSubnetId)
      .optionallyWith(
        firewallSubnetRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firewallSubnetRoutes)
      .optionallyWith(
        internetGatewayId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.internetGatewayId)
      .optionallyWith(
        currentInternetGatewayRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentInternetGatewayRouteTable)
      .optionallyWith(
        internetGatewayRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.internetGatewayRoutes)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.ReadOnly =
    zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.wrap(buildAwsValue())
}
object RouteHasOutOfScopeEndpointViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation =
      zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation(
        subnetId.map(value => value),
        vpcId.map(value => value),
        routeTableId.map(value => value),
        violatingRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subnetAvailabilityZone.map(value => value),
        subnetAvailabilityZoneId.map(value => value),
        currentFirewallSubnetRouteTable.map(value => value),
        firewallSubnetId.map(value => value),
        firewallSubnetRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        internetGatewayId.map(value => value),
        currentInternetGatewayRouteTable.map(value => value),
        internetGatewayRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subnetId: Optional[ResourceId]
    def vpcId: Optional[ResourceId]
    def routeTableId: Optional[ResourceId]
    def violatingRoutes: Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def subnetAvailabilityZone: Optional[LengthBoundedString]
    def subnetAvailabilityZoneId: Optional[LengthBoundedString]
    def currentFirewallSubnetRouteTable: Optional[ResourceId]
    def firewallSubnetId: Optional[ResourceId]
    def firewallSubnetRoutes: Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def internetGatewayId: Optional[ResourceId]
    def currentInternetGatewayRouteTable: Optional[ResourceId]
    def internetGatewayRoutes: Optional[List[zio.aws.fms.model.Route.ReadOnly]]
    def getSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getViolatingRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("violatingRoutes", violatingRoutes)
    def getSubnetAvailabilityZone: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZone",
        subnetAvailabilityZone
      )
    def getSubnetAvailabilityZoneId: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZoneId",
        subnetAvailabilityZoneId
      )
    def getCurrentFirewallSubnetRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentFirewallSubnetRouteTable",
        currentFirewallSubnetRouteTable
      )
    def getFirewallSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallSubnetId", firewallSubnetId)
    def getFirewallSubnetRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("firewallSubnetRoutes", firewallSubnetRoutes)
    def getInternetGatewayId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("internetGatewayId", internetGatewayId)
    def getCurrentInternetGatewayRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentInternetGatewayRouteTable",
        currentInternetGatewayRouteTable
      )
    def getInternetGatewayRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("internetGatewayRoutes", internetGatewayRoutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation
  ) extends zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.ReadOnly {
    override val subnetId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val vpcId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val routeTableId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val violatingRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violatingRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
    override val subnetAvailabilityZone: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetAvailabilityZone())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val subnetAvailabilityZoneId: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetAvailabilityZoneId())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val currentFirewallSubnetRouteTable: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentFirewallSubnetRouteTable())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val firewallSubnetId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallSubnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val firewallSubnetRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallSubnetRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
    override val internetGatewayId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.internetGatewayId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val currentInternetGatewayRouteTable: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentInternetGatewayRouteTable())
        .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val internetGatewayRoutes
        : Optional[List[zio.aws.fms.model.Route.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.internetGatewayRoutes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.Route.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation
  ): zio.aws.fms.model.RouteHasOutOfScopeEndpointViolation.ReadOnly =
    new Wrapper(impl)
}
