package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.RemediationActionDescription
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SecurityGroupRemediationAction(
    remediationActionType: Optional[zio.aws.fms.model.RemediationActionType] =
      Optional.Absent,
    description: Optional[RemediationActionDescription] = Optional.Absent,
    remediationResult: Optional[
      zio.aws.fms.model.SecurityGroupRuleDescription
    ] = Optional.Absent,
    isDefaultAction: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction = {
    import SecurityGroupRemediationAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction
      .builder()
      .optionallyWith(remediationActionType.map(value => value.unwrap))(
        _.remediationActionType
      )
      .optionallyWith(
        description.map(value =>
          RemediationActionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(remediationResult.map(value => value.buildAwsValue()))(
        _.remediationResult
      )
      .optionallyWith(isDefaultAction.map(value => value: java.lang.Boolean))(
        _.isDefaultAction
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.SecurityGroupRemediationAction.ReadOnly =
    zio.aws.fms.model.SecurityGroupRemediationAction.wrap(buildAwsValue())
}
object SecurityGroupRemediationAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.SecurityGroupRemediationAction =
      zio.aws.fms.model.SecurityGroupRemediationAction(
        remediationActionType.map(value => value),
        description.map(value => value),
        remediationResult.map(value => value.asEditable),
        isDefaultAction.map(value => value)
      )
    def remediationActionType: Optional[zio.aws.fms.model.RemediationActionType]
    def description: Optional[RemediationActionDescription]
    def remediationResult
        : Optional[zio.aws.fms.model.SecurityGroupRuleDescription.ReadOnly]
    def isDefaultAction: Optional[Boolean]
    def getRemediationActionType
        : ZIO[Any, AwsError, zio.aws.fms.model.RemediationActionType] =
      AwsError.unwrapOptionField("remediationActionType", remediationActionType)
    def getDescription: ZIO[Any, AwsError, RemediationActionDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRemediationResult: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.SecurityGroupRuleDescription.ReadOnly
    ] = AwsError.unwrapOptionField("remediationResult", remediationResult)
    def getIsDefaultAction: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefaultAction", isDefaultAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction
  ) extends zio.aws.fms.model.SecurityGroupRemediationAction.ReadOnly {
    override val remediationActionType
        : Optional[zio.aws.fms.model.RemediationActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remediationActionType())
        .map(value => zio.aws.fms.model.RemediationActionType.wrap(value))
    override val description: Optional[RemediationActionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.fms.model.primitives.RemediationActionDescription(value)
        )
    override val remediationResult
        : Optional[zio.aws.fms.model.SecurityGroupRuleDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remediationResult())
        .map(value =>
          zio.aws.fms.model.SecurityGroupRuleDescription.wrap(value)
        )
    override val isDefaultAction: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefaultAction())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction
  ): zio.aws.fms.model.SecurityGroupRemediationAction.ReadOnly = new Wrapper(
    impl
  )
}
