package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{ResourceId, NetworkFirewallResourceName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StatefulRuleGroup(
    ruleGroupName: Optional[NetworkFirewallResourceName] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.StatefulRuleGroup = {
    import StatefulRuleGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.StatefulRuleGroup
      .builder()
      .optionallyWith(
        ruleGroupName.map(value =>
          NetworkFirewallResourceName.unwrap(value): java.lang.String
        )
      )(_.ruleGroupName)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.StatefulRuleGroup.ReadOnly =
    zio.aws.fms.model.StatefulRuleGroup.wrap(buildAwsValue())
}
object StatefulRuleGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.StatefulRuleGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.StatefulRuleGroup =
      zio.aws.fms.model.StatefulRuleGroup(
        ruleGroupName.map(value => value),
        resourceId.map(value => value)
      )
    def ruleGroupName: Optional[NetworkFirewallResourceName]
    def resourceId: Optional[ResourceId]
    def getRuleGroupName: ZIO[Any, AwsError, NetworkFirewallResourceName] =
      AwsError.unwrapOptionField("ruleGroupName", ruleGroupName)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.StatefulRuleGroup
  ) extends zio.aws.fms.model.StatefulRuleGroup.ReadOnly {
    override val ruleGroupName: Optional[NetworkFirewallResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroupName())
        .map(value =>
          zio.aws.fms.model.primitives.NetworkFirewallResourceName(value)
        )
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.StatefulRuleGroup
  ): zio.aws.fms.model.StatefulRuleGroup.ReadOnly = new Wrapper(impl)
}
