package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{FirewallPolicyName, FirewallPolicyId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ThirdPartyFirewallFirewallPolicy(
    firewallPolicyId: Optional[FirewallPolicyId] = Optional.Absent,
    firewallPolicyName: Optional[FirewallPolicyName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ThirdPartyFirewallFirewallPolicy = {
    import ThirdPartyFirewallFirewallPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ThirdPartyFirewallFirewallPolicy
      .builder()
      .optionallyWith(
        firewallPolicyId.map(value =>
          FirewallPolicyId.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyId)
      .optionallyWith(
        firewallPolicyName.map(value =>
          FirewallPolicyName.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyName)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy.ReadOnly =
    zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy.wrap(buildAwsValue())
}
object ThirdPartyFirewallFirewallPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ThirdPartyFirewallFirewallPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy =
      zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy(
        firewallPolicyId.map(value => value),
        firewallPolicyName.map(value => value)
      )
    def firewallPolicyId: Optional[FirewallPolicyId]
    def firewallPolicyName: Optional[FirewallPolicyName]
    def getFirewallPolicyId: ZIO[Any, AwsError, FirewallPolicyId] =
      AwsError.unwrapOptionField("firewallPolicyId", firewallPolicyId)
    def getFirewallPolicyName: ZIO[Any, AwsError, FirewallPolicyName] =
      AwsError.unwrapOptionField("firewallPolicyName", firewallPolicyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ThirdPartyFirewallFirewallPolicy
  ) extends zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy.ReadOnly {
    override val firewallPolicyId: Optional[FirewallPolicyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyId())
        .map(value => zio.aws.fms.model.primitives.FirewallPolicyId(value))
    override val firewallPolicyName: Optional[FirewallPolicyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyName())
        .map(value => zio.aws.fms.model.primitives.FirewallPolicyName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ThirdPartyFirewallFirewallPolicy
  ): zio.aws.fms.model.ThirdPartyFirewallFirewallPolicy.ReadOnly = new Wrapper(
    impl
  )
}
